/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.convention.impl;

import junit.framework.Test;
import junit.framework.TestCase;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.convention.impl.dao.AaaDao;
import org.seasar.framework.convention.impl.dao.BbbDao;
import org.seasar.framework.convention.impl.dao.impl.BbbDaoImpl;
import org.seasar.framework.convention.impl.dao.impl.Ddd1DaoImpl;
import org.seasar.framework.convention.impl.dao.impl.Ddd2DaoImpl;
import org.seasar.framework.convention.impl.dao.xxx.CccDao;
import org.seasar.framework.convention.impl.web.add.DddPage;
import org.seasar.framework.convention.impl.web.add.xxx.AddXxxPage;
import org.seasar.framework.convention.impl.web.web.foo.FffPage;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourcesUtil;

public class NamingConventionImplTest
extends TestCase {
    private NamingConventionImpl convention;
    private String rootPackageName;

    protected void setUp() {
        this.convention = new NamingConventionImpl();
        this.rootPackageName = ClassUtil.getPackageName(((Object)((Object)this)).getClass());
        this.convention.addRootPackageName(this.rootPackageName);
        this.convention.addIgnorePackageName(this.rootPackageName + ".web.ignore");
    }

    public void testAddAndGetRootPackageName() throws Exception {
        ResourcesUtil.Resources[] checkers = this.convention.getExistCheckerArray(this.rootPackageName);
        NamingConventionImplTest.assertNotNull((Object)checkers);
        NamingConventionImplTest.assertEquals((Object)ResourcesUtil.FileSystemResources.class, checkers[0].getClass());
    }

    public void testAddAndGetIgnorePackageName() throws Exception {
        String[] ignorePackageNames = this.convention.getIgnorePackageNames();
        ignorePackageNames = this.convention.getIgnorePackageNames();
        NamingConventionImplTest.assertEquals((int)1, (int)ignorePackageNames.length);
        NamingConventionImplTest.assertEquals((String)"org.seasar.framework.convention.impl.web.ignore", (String)ignorePackageNames[0]);
    }

    public void testFromSuffixToPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"logic", (String)this.convention.fromSuffixToPackageName("Logic"));
        NamingConventionImplTest.assertEquals((String)"directorydao", (String)this.convention.fromSuffixToPackageName("DirectoryDao"));
    }

    public void testGetImplementationPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"impl", (String)this.convention.getImplementationPackageName());
    }

    public void testGetDxoPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"dxo", (String)this.convention.getDxoPackageName());
    }

    public void testGetLogicPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"logic", (String)this.convention.getLogicPackageName());
    }

    public void testGetDaoPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"dao", (String)this.convention.getDaoPackageName());
    }

    public void testGetDtoPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"dto", (String)this.convention.getDtoPackageName());
    }

    public void testGetServicePackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"service", (String)this.convention.getServicePackageName());
    }

    public void testGetInterceptorPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"interceptor", (String)this.convention.getInterceptorPackageName());
    }

    public void testGetValidatorPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"validator", (String)this.convention.getValidatorPackageName());
    }

    public void testGetConverterPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"converter", (String)this.convention.getConverterPackageName());
    }

    public void testGetHelperPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"helper", (String)this.convention.getHelperPackageName());
    }

    public void testGetConnectorPackageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"connector", (String)this.convention.getConnectorPackageName());
    }

    public void testFromClassNameToComponentName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"abcLogic", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.logic.impl.AbcLogicImpl"));
        NamingConventionImplTest.assertEquals((String)"abcInterceptor", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.interceptor.AbcInterceptor"));
        NamingConventionImplTest.assertEquals((String)"add_addPage", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.web.add.AddPage"));
        NamingConventionImplTest.assertEquals((String)"add_xxx_addPage", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.web.add.xxx.AddPage"));
        NamingConventionImplTest.assertEquals((String)"add_addDxo", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.web.add.impl.AddDxoImpl"));
        NamingConventionImplTest.assertEquals((String)"bbb_cccDao", (String)this.convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.dao.bbb.CccDao"));
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".web");
        NamingConventionImplTest.assertEquals((String)"foo_fffPage", (String)convention.fromClassNameToComponentName("org.seasar.framework.convention.impl.web.web.foo.FffPage"));
    }

    public void testFromClassNameToComponentName_performance() throws Exception {
        int num = 10000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            this.convention.fromClassNameToComponentName("aaa.web.add.AddPage");
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("fromClassNameToComponentName:" + num + "=" + time);
    }

    public void testFromComponentNameToSuffix() throws Exception {
        NamingConventionImplTest.assertEquals((String)"Logic", (String)this.convention.fromComponentNameToSuffix("aaaLogic"));
        NamingConventionImplTest.assertNull((Object)this.convention.fromComponentNameToSuffix("aaa"));
    }

    public void testFromComponentNameToPartOfClassName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"AaaLogic", (String)this.convention.fromComponentNameToPartOfClassName("aaaLogic"));
        NamingConventionImplTest.assertEquals((String)"xxx.AaaLogic", (String)this.convention.fromComponentNameToPartOfClassName("xxx_aaaLogic"));
        NamingConventionImplTest.assertEquals((String)"xxx.yyy.AaaLogic", (String)this.convention.fromComponentNameToPartOfClassName("xxx_yyy_aaaLogic"));
    }

    public void testToImplementationClassName() throws Exception {
        this.convention.addInterfaceToImplementationClassName("BbbLogic", "mock.BbbLogicMock");
        this.convention.addInterfaceToImplementationClassName("abc.logic.CccLogic", "abc.logic.mock.CccLogicMock");
        NamingConventionImplTest.assertEquals((String)"impl.AaaLogicImpl", (String)this.convention.toImplementationClassName("AaaLogic"));
        NamingConventionImplTest.assertEquals((String)"abc.logic.impl.AaaLogicImpl", (String)this.convention.toImplementationClassName("abc.logic.AaaLogic"));
        NamingConventionImplTest.assertEquals((String)"mock.BbbLogicMock", (String)this.convention.toImplementationClassName("BbbLogic"));
        NamingConventionImplTest.assertEquals((String)"abc.logic.mock.CccLogicMock", (String)this.convention.toImplementationClassName("abc.logic.CccLogic"));
    }

    public void testToInterfaceClassName() throws Exception {
        this.convention.addInterfaceToImplementationClassName("AaaDao", "mock.AaaDaoMock");
        this.convention.addInterfaceToImplementationClassName("abc.dao.CccDao", "abc.dao.mock.CccDaoMock");
        NamingConventionImplTest.assertEquals((String)"aaa.dao.BbbDao", (String)this.convention.toInterfaceClassName("aaa.dao.BbbDao"));
        NamingConventionImplTest.assertEquals((String)"aaa.dao.BbbDao", (String)this.convention.toInterfaceClassName("aaa.dao.impl.BbbDaoImpl"));
        NamingConventionImplTest.assertEquals((String)"AaaDao", (String)this.convention.toInterfaceClassName("mock.AaaDaoMock"));
        NamingConventionImplTest.assertEquals((String)"abc.dao.CccDao", (String)this.convention.toInterfaceClassName("abc.dao.mock.CccDaoMock"));
    }

    public void testToCompleteClass() throws Exception {
        NamingConventionImplTest.assertEquals((Object)AaaDao.class, (Object)this.convention.toCompleteClass(AaaDao.class));
        NamingConventionImplTest.assertEquals((Object)BbbDaoImpl.class, (Object)this.convention.toCompleteClass(BbbDao.class));
        NamingConventionImplTest.assertEquals((Object)DddPage.class, (Object)this.convention.toCompleteClass(DddPage.class));
    }

    public void testFromComponentNameToClass() throws Exception {
        NamingConventionImplTest.assertEquals((Object)AaaDao.class, (Object)this.convention.fromComponentNameToClass("aaaDao"));
        NamingConventionImplTest.assertEquals((Object)BbbDaoImpl.class, (Object)this.convention.fromComponentNameToClass("bbbDao"));
        NamingConventionImplTest.assertEquals((Object)CccDao.class, (Object)this.convention.fromComponentNameToClass("xxx_cccDao"));
        NamingConventionImplTest.assertEquals((Object)Ddd1DaoImpl.class, (Object)this.convention.fromComponentNameToClass("ddd1Dao"));
        NamingConventionImplTest.assertEquals((Object)Ddd2DaoImpl.class, (Object)this.convention.fromComponentNameToClass("ddd2Dao"));
        NamingConventionImplTest.assertEquals((Object)DddPage.class, (Object)this.convention.fromComponentNameToClass("add_dddPage"));
        NamingConventionImplTest.assertEquals((Object)AddXxxPage.class, (Object)this.convention.fromComponentNameToClass("add_xxx_addXxxPage"));
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".web");
        NamingConventionImplTest.assertEquals((Object)FffPage.class, (Object)convention.fromComponentNameToClass("foo_fffPage"));
    }

    public void testFromComponentNameToClass_performance() throws Exception {
        int num = 10000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            this.convention.fromComponentNameToClass("bbbDao");
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("fromComponentNameToClass:" + num + "=" + time);
    }

    public void testFindClass() throws Exception {
        NamingConventionImplTest.assertEquals((Object)AaaDao.class, (Object)this.convention.findClass(this.rootPackageName, "dao", "AaaDao"));
        NamingConventionImplTest.assertEquals((Object)BbbDaoImpl.class, (Object)this.convention.findClass(this.rootPackageName, "dao", "BbbDao"));
        NamingConventionImplTest.assertEquals((Object)DddPage.class, (Object)this.convention.findClass(this.rootPackageName, "web.add", "DddPage"));
        NamingConventionImplTest.assertNull((Object)this.convention.findClass(this.rootPackageName, "web.ignore", "EeePage"));
        this.convention.dispose();
        NamingConventionImplTest.assertEquals((Object)AaaDao.class, (Object)this.convention.findClass(this.rootPackageName, "dao", "AaaDao"));
    }

    public void testFindClass_performance() throws Exception {
        int num = 10000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            this.convention.findClass(this.rootPackageName, "dao", "BbbDao");
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("findClass:" + num + "=" + time);
    }

    public void testFromClassNameToShortComponentName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"abcLogic", (String)this.convention.fromClassNameToShortComponentName("aaa.logic.impl.AbcLogicImpl"));
        NamingConventionImplTest.assertEquals((String)"abcInterceptor", (String)this.convention.fromClassNameToShortComponentName("aaa.interceptor.AbcInterceptor"));
    }

    public void testIsTargetClassName() throws Exception {
        NamingConventionImplTest.assertTrue((boolean)this.convention.isTargetClassName(this.rootPackageName + ".dao.AaaDao"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isTargetClassName(this.rootPackageName + ".web.ignore.EeePage"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isTargetClassName("hoge.dao.AaaDao"));
        NamingConventionImplTest.assertTrue((boolean)this.convention.isTargetClassName(this.rootPackageName + ".dao.AaaDao", "Dao"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isTargetClassName(this.rootPackageName + ".dao.AaaDao", "Service"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isTargetClassName("foo.bar.dao.AaaDao", "Dao"));
    }

    public void testIsIgnoreClassName() throws Exception {
        NamingConventionImplTest.assertTrue((boolean)this.convention.isIgnoreClassName(this.rootPackageName + ".web.ignore.EeePage"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isIgnoreClassName(this.rootPackageName + ".web.add.DddPage"));
    }

    public void testFromPathToPageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"hogePage", (String)this.convention.fromPathToPageName("/view/hoge.html"));
        NamingConventionImplTest.assertEquals((String)"hogePage", (String)this.convention.fromPathToPageName("/view/Hoge.html"));
        NamingConventionImplTest.assertEquals((String)"hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/Foo.html"));
        NamingConventionImplTest.assertEquals((String)"aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/Foo.html"));
    }

    public void testFromPathToPageName2() throws Exception {
        this.convention.setViewRootPath("");
        NamingConventionImplTest.assertEquals((String)"view_hogePage", (String)this.convention.fromPathToPageName("/view/hoge.html"));
        NamingConventionImplTest.assertEquals((String)"view_hogePage", (String)this.convention.fromPathToPageName("/view/Hoge.html"));
        NamingConventionImplTest.assertEquals((String)"view_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/Foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/Foo.html"));
    }

    public void testFromPathToPageName3() throws Exception {
        this.convention.setViewRootPath("/");
        NamingConventionImplTest.assertEquals((String)"view_hogePage", (String)this.convention.fromPathToPageName("/view/hoge.html"));
        NamingConventionImplTest.assertEquals((String)"view_hogePage", (String)this.convention.fromPathToPageName("/view/Hoge.html"));
        NamingConventionImplTest.assertEquals((String)"view_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/hoge/Foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"view_aaa_hoge_fooPage", (String)this.convention.fromPathToPageName("/view/aaa/hoge/Foo.html"));
    }

    public void testFromPathToActionName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"hogeAction", (String)this.convention.fromPathToActionName("/view/hoge.html"));
        NamingConventionImplTest.assertEquals((String)"hoge_fooAction", (String)this.convention.fromPathToActionName("/view/hoge/foo.html"));
        NamingConventionImplTest.assertEquals((String)"aaa_hoge_fooAction", (String)this.convention.fromPathToActionName("/view/aaa/hoge/foo.html"));
    }

    public void testFromPageNameToPath() throws Exception {
        NamingConventionImplTest.assertEquals((String)"/view/hoge.html", (String)this.convention.fromPageNameToPath("hogePage"));
        NamingConventionImplTest.assertEquals((String)"/view/aaa/hoge.html", (String)this.convention.fromPageNameToPath("aaa_hogePage"));
        NamingConventionImplTest.assertEquals((String)"/view/aaa/bbb/hoge.html", (String)this.convention.fromPageNameToPath("aaa_bbb_hogePage"));
    }

    public void testFromPageNameToPath2() throws Exception {
        this.convention.setViewRootPath("/");
        NamingConventionImplTest.assertEquals((String)"/hoge.html", (String)this.convention.fromPageNameToPath("hogePage"));
        NamingConventionImplTest.assertEquals((String)"/aaa/hoge.html", (String)this.convention.fromPageNameToPath("aaa_hogePage"));
        NamingConventionImplTest.assertEquals((String)"/aaa/bbb/hoge.html", (String)this.convention.fromPageNameToPath("aaa_bbb_hogePage"));
    }

    public void testFromPageClassToPath() throws Exception {
        this.convention.setViewRootPath("/view");
        NamingConventionImplTest.assertEquals((String)"/view/add/ddd.html", (String)this.convention.fromPageClassToPath(DddPage.class));
        this.convention.setViewRootPath("/");
        NamingConventionImplTest.assertEquals((String)"/add/ddd.html", (String)this.convention.fromPageClassToPath(DddPage.class));
    }

    public void testFromActionNameToPath() throws Exception {
        NamingConventionImplTest.assertEquals((String)"/view/hoge.html", (String)this.convention.fromActionNameToPath("hogeAction"));
        NamingConventionImplTest.assertEquals((String)"/view/aaa/hoge.html", (String)this.convention.fromActionNameToPath("aaa_hogeAction"));
        NamingConventionImplTest.assertEquals((String)"/view/aaa/bbb/hoge.html", (String)this.convention.fromActionNameToPath("aaa_bbb_hogeAction"));
    }

    public void testFromActionNameToPath2() throws Exception {
        this.convention.setViewRootPath("/");
        NamingConventionImplTest.assertEquals((String)"/hoge.html", (String)this.convention.fromActionNameToPath("hogeAction"));
        NamingConventionImplTest.assertEquals((String)"/aaa/hoge.html", (String)this.convention.fromActionNameToPath("aaa_hogeAction"));
        NamingConventionImplTest.assertEquals((String)"/aaa/bbb/hoge.html", (String)this.convention.fromActionNameToPath("aaa_bbb_hogeAction"));
    }

    public void testFromActionNameToPageName() throws Exception {
        NamingConventionImplTest.assertEquals((String)"hogePage", (String)this.convention.fromActionNameToPageName("hogeAction"));
        NamingConventionImplTest.assertEquals((String)"aaa_hogePage", (String)this.convention.fromActionNameToPageName("aaa_hogeAction"));
        NamingConventionImplTest.assertEquals((String)"aaa_bbb_hogePage", (String)this.convention.fromActionNameToPageName("aaa_bbb_hogeAction"));
    }

    public void testIsExist() throws Exception {
        NamingConventionImplTest.assertTrue((boolean)this.convention.isExist(this.rootPackageName, "dao.AaaDao"));
        NamingConventionImplTest.assertTrue((boolean)this.convention.isExist(this.rootPackageName, "dao.BbbDao"));
        NamingConventionImplTest.assertTrue((boolean)this.convention.isExist(this.rootPackageName, "web.add.DddPage"));
        NamingConventionImplTest.assertTrue((boolean)this.convention.isExist(this.rootPackageName, "web.ignore.EeePage"));
        NamingConventionImplTest.assertFalse((boolean)this.convention.isExist(this.rootPackageName, "dao.xxxDao"));
    }

    public void testIsExist_jar() throws Exception {
        NamingConventionImpl nc = new NamingConventionImpl();
        nc.addRootPackageName("junit.framework");
        NamingConventionImplTest.assertEquals((Object)Test.class, (Object)nc.findClass("junit.framework", "", "Test"));
        NamingConventionImplTest.assertNull((Object)nc.findClass("junit.framework", "", "xxx"));
    }

    public void testIsValidViewRootPath() throws Exception {
        NamingConventionImpl nc = new NamingConventionImpl();
        nc.setViewRootPath("/view");
        nc.setViewExtension(".html");
        NamingConventionImplTest.assertTrue((boolean)nc.isValidViewRootPath("/view/hoge.html"));
    }

    public void testIsValidViewRootPath_viewExtIsNotSuitable() throws Exception {
        NamingConventionImpl nc = new NamingConventionImpl();
        nc.setViewRootPath("/view");
        nc.setViewExtension(".jsp");
        NamingConventionImplTest.assertFalse((boolean)nc.isValidViewRootPath("/view/hoge.html"));
    }

    public void testIsValidViewRootPath_viewRootPathIsNotSuitable() throws Exception {
        NamingConventionImpl nc = new NamingConventionImpl();
        nc.setViewRootPath("/pages");
        nc.setViewExtension(".html");
        NamingConventionImplTest.assertFalse((boolean)nc.isValidViewRootPath("/view/hoge.html"));
    }
}

