/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.event;

import java.util.ArrayList;
import org.apache.poi.hdf.event.HDFLowLevelParsingListener;
import org.apache.poi.hdf.event.HDFParsingListener;
import org.apache.poi.hdf.model.hdftypes.CharacterProperties;
import org.apache.poi.hdf.model.hdftypes.ChpxNode;
import org.apache.poi.hdf.model.hdftypes.DocumentProperties;
import org.apache.poi.hdf.model.hdftypes.FontTable;
import org.apache.poi.hdf.model.hdftypes.HeaderFooter;
import org.apache.poi.hdf.model.hdftypes.LVL;
import org.apache.poi.hdf.model.hdftypes.ListTables;
import org.apache.poi.hdf.model.hdftypes.PapxNode;
import org.apache.poi.hdf.model.hdftypes.ParagraphProperties;
import org.apache.poi.hdf.model.hdftypes.SectionProperties;
import org.apache.poi.hdf.model.hdftypes.SepxNode;
import org.apache.poi.hdf.model.hdftypes.StyleDescription;
import org.apache.poi.hdf.model.hdftypes.StyleSheet;
import org.apache.poi.hdf.model.hdftypes.TableProperties;
import org.apache.poi.hdf.model.hdftypes.TextPiece;
import org.apache.poi.hdf.model.util.BTreeSet;
import org.apache.poi.hdf.model.util.NumberFormatter;
import org.apache.poi.util.LittleEndian;

public class EventBridge
implements HDFLowLevelParsingListener {
    private static int HEADER_EVEN_INDEX = 0;
    private static int HEADER_ODD_INDEX = 1;
    private static int FOOTER_EVEN_INDEX = 2;
    private static int FOOTER_ODD_INDEX = 3;
    private static int HEADER_FIRST_INDEX = 4;
    private static int FOOTER_FIRST_INDEX = 5;
    HDFParsingListener _listener;
    StyleSheet _stsh;
    DocumentProperties _dop;
    StyleDescription _currentStd;
    ListTables _listTables;
    byte[] _mainDocument;
    byte[] _tableStream;
    int _fcMin;
    int _ccpText;
    int _ccpFtn;
    int _hdrSize;
    int _hdrOffset;
    BTreeSet _text = new BTreeSet();
    private boolean _beginHeaders;
    BTreeSet _hdrSections = new BTreeSet();
    BTreeSet _hdrParagraphs = new BTreeSet();
    BTreeSet _hdrCharacterRuns = new BTreeSet();
    int _sectionCounter = 1;
    ArrayList _hdrs = new ArrayList();
    private boolean _holdParagraph = false;
    private int _endHoldIndex = -1;
    private ArrayList _onHold;

    public EventBridge(HDFParsingListener listener) {
        this._listener = listener;
    }

    public void mainDocument(byte[] mainDocument) {
        this._mainDocument = mainDocument;
    }

    public void tableStream(byte[] tableStream) {
        this._tableStream = tableStream;
    }

    public void miscellaneous(int fcMin, int ccpText, int ccpFtn, int fcPlcfhdd, int lcbPlcfhdd) {
        this._fcMin = fcMin;
        this._ccpText = ccpText;
        this._ccpFtn = ccpFtn;
        this._hdrOffset = fcPlcfhdd;
        this._hdrSize = lcbPlcfhdd;
    }

    public void document(DocumentProperties dop) {
        this._dop = dop;
    }

    public void bodySection(SepxNode sepx) {
        SectionProperties sep = (SectionProperties)StyleSheet.uncompressProperty(sepx.getSepx(), new SectionProperties(), this._stsh);
        HeaderFooter[] hdrArray = this.findSectionHdrFtrs(this._sectionCounter);
        this._hdrs.add(hdrArray);
        this._listener.section(sep, sepx.getStart() - this._fcMin, sepx.getEnd() - this._fcMin);
        ++this._sectionCounter;
    }

    public void hdrSection(SepxNode sepx) {
        this._beginHeaders = true;
        this._hdrSections.add(sepx);
    }

    public void endSections() {
        for (int x = 1; x < this._sectionCounter; ++x) {
            HeaderFooter[] hdrArray = (HeaderFooter[])this._hdrs.get(x - 1);
            HeaderFooter hf = null;
            if (!hdrArray[0].isEmpty()) {
                hf = hdrArray[0];
                this._listener.header(x - 1, 1);
                this.flushHeaderProps(hf.getStart(), hf.getEnd());
            }
            if (!hdrArray[1].isEmpty()) {
                hf = hdrArray[1];
                this._listener.header(x - 1, 2);
                this.flushHeaderProps(hf.getStart(), hf.getEnd());
            }
            if (!hdrArray[2].isEmpty()) {
                hf = hdrArray[2];
                this._listener.footer(x - 1, 3);
                this.flushHeaderProps(hf.getStart(), hf.getEnd());
            }
            if (!hdrArray[3].isEmpty()) {
                hf = hdrArray[2];
                this._listener.footer(x - 1, 3);
                this.flushHeaderProps(hf.getStart(), hf.getEnd());
            }
            if (!hdrArray[4].isEmpty()) {
                hf = hdrArray[4];
                this._listener.header(x - 1, 5);
                this.flushHeaderProps(hf.getStart(), hf.getEnd());
            }
            if (hdrArray[5].isEmpty()) continue;
            hf = hdrArray[5];
            this._listener.footer(x - 1, 6);
            this.flushHeaderProps(hf.getStart(), hf.getEnd());
        }
    }

    public void paragraph(PapxNode papx) {
        if (this._beginHeaders) {
            this._hdrParagraphs.add(papx);
        }
        byte[] bytePapx = papx.getPapx();
        short istd = LittleEndian.getShort(bytePapx, 0);
        this._currentStd = this._stsh.getStyleDescription(istd);
        ParagraphProperties pap = (ParagraphProperties)StyleSheet.uncompressProperty(bytePapx, this._currentStd.getPAP(), this._stsh);
        if (pap.getFTtp() > 0) {
            TableProperties tap = (TableProperties)StyleSheet.uncompressProperty(bytePapx, new TableProperties(), this._stsh);
            this._listener.tableRowEnd(tap, papx.getStart() - this._fcMin, papx.getEnd() - this._fcMin);
        } else if (pap.getIlfo() > 0) {
            this._holdParagraph = true;
            this._endHoldIndex = papx.getEnd();
            this._onHold.add(papx);
        } else {
            this._listener.paragraph(pap, papx.getStart() - this._fcMin, papx.getEnd() - this._fcMin);
        }
    }

    public void characterRun(ChpxNode chpx) {
        if (this._beginHeaders) {
            this._hdrCharacterRuns.add(chpx);
        }
        int start = chpx.getStart();
        int end = chpx.getEnd();
        if (this._holdParagraph) {
            this._onHold.add(chpx);
            if (end >= this._endHoldIndex) {
                this._holdParagraph = false;
                this._endHoldIndex = -1;
                this.flushHeldParagraph();
                this._onHold = new ArrayList();
            }
        }
        byte[] byteChpx = chpx.getChpx();
        CharacterProperties chp = (CharacterProperties)StyleSheet.uncompressProperty(byteChpx, this._currentStd.getCHP(), this._stsh);
        ArrayList textList = BTreeSet.findProperties(start, end, this._text.root);
        String text = this.getTextFromNodes(textList, start, end);
        this._listener.characterRun(chp, text, start - this._fcMin, end - this._fcMin);
    }

    public void text(TextPiece t) {
        this._text.add(t);
    }

    public void fonts(FontTable fontTbl) {
    }

    public void lists(ListTables listTbl) {
        this._listTables = listTbl;
    }

    public void styleSheet(StyleSheet stsh) {
        this._stsh = stsh;
    }

    private void flushHeaderProps(int start, int end) {
        ArrayList list = BTreeSet.findProperties(start, end, this._hdrSections.root);
        int size = list.size();
        for (int x = 0; x < size; ++x) {
            SepxNode oldNode = (SepxNode)list.get(x);
            int secStart = Math.max(oldNode.getStart(), start);
            int secEnd = Math.min(oldNode.getEnd(), end);
            ArrayList parList = BTreeSet.findProperties(secStart, secEnd, this._hdrParagraphs.root);
            int parSize = parList.size();
            for (int y = 0; y < parSize; ++y) {
                PapxNode oldParNode = (PapxNode)parList.get(y);
                int parStart = Math.max(oldParNode.getStart(), secStart);
                int parEnd = Math.min(oldParNode.getEnd(), secEnd);
                PapxNode parNode = new PapxNode(parStart, parEnd, oldParNode.getPapx());
                this.paragraph(parNode);
                ArrayList charList = BTreeSet.findProperties(parStart, parEnd, this._hdrCharacterRuns.root);
                int charSize = charList.size();
                for (int z = 0; z < charSize; ++z) {
                    ChpxNode oldCharNode = (ChpxNode)charList.get(z);
                    int charStart = Math.max(oldCharNode.getStart(), parStart);
                    int charEnd = Math.min(oldCharNode.getEnd(), parEnd);
                    ChpxNode charNode = new ChpxNode(charStart, charEnd, oldCharNode.getChpx());
                    this.characterRun(charNode);
                }
            }
        }
    }

    private String getTextFromNodes(ArrayList list, int start, int end) {
        int size = list.size();
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < size; ++x) {
            int y;
            TextPiece piece = (TextPiece)list.get(x);
            int charStart = Math.max(start, piece.getStart());
            int charEnd = Math.min(end, piece.getEnd());
            if (piece.usesUnicode()) {
                for (y = charStart; y < charEnd; y += 2) {
                    sb.append((char)LittleEndian.getShort(this._mainDocument, y));
                }
                continue;
            }
            for (y = charStart; y < charEnd; ++y) {
                sb.append(this._mainDocument[y]);
            }
        }
        return sb.toString();
    }

    private void flushHeldParagraph() {
        PapxNode papx = (PapxNode)this._onHold.get(0);
        byte[] bytePapx = papx.getPapx();
        short istd = LittleEndian.getShort(bytePapx, 0);
        StyleDescription std = this._stsh.getStyleDescription(istd);
        ParagraphProperties pap = (ParagraphProperties)StyleSheet.uncompressProperty(bytePapx, this._currentStd.getPAP(), this._stsh);
        LVL lvl = this._listTables.getLevel(pap.getIlfo(), pap.getIlvl());
        pap = (ParagraphProperties)StyleSheet.uncompressProperty(lvl._papx, pap, this._stsh, false);
        int size = this._onHold.size() - 1;
        CharacterProperties numChp = (CharacterProperties)StyleSheet.uncompressProperty(((ChpxNode)this._onHold.get(size)).getChpx(), std.getCHP(), this._stsh);
        numChp = (CharacterProperties)StyleSheet.uncompressProperty(lvl._chpx, numChp, this._stsh);
        String bulletText = this.getBulletText(lvl, pap);
        this._listener.listEntry(bulletText, numChp, pap, papx.getStart() - this._fcMin, papx.getEnd() - this._fcMin);
        for (int x = 1; x <= size; ++x) {
            this.characterRun((ChpxNode)this._onHold.get(x));
        }
    }

    private String getBulletText(LVL lvl, ParagraphProperties pap) {
        StringBuffer bulletBuffer = new StringBuffer();
        for (int x = 0; x < lvl._xst.length; ++x) {
            if (lvl._xst[x] < '\t') {
                LVL numLevel = this._listTables.getLevel(pap.getIlfo(), lvl._xst[x]);
                int num = numLevel._iStartAt++;
                if (lvl != numLevel && num > 1) {
                    --num;
                }
                bulletBuffer.append(NumberFormatter.getNumber(num, lvl._nfc));
                continue;
            }
            bulletBuffer.append(lvl._xst[x]);
        }
        switch (lvl._ixchFollow) {
            case 0: {
                bulletBuffer.append('\t');
                break;
            }
            case 1: {
                bulletBuffer.append(' ');
            }
        }
        return bulletBuffer.toString();
    }

    private HeaderFooter[] findSectionHdrFtrs(int index) {
        HeaderFooter[] hdrArray = new HeaderFooter[6];
        for (int x = 1; x < 7; ++x) {
            hdrArray[x - 1] = this.createSectionHdrFtr(index, x);
        }
        return hdrArray;
    }

    private HeaderFooter createSectionHdrFtr(int index, int type) {
        int start;
        if (this._hdrSize < 50) {
            return new HeaderFooter(0, 0, 0);
        }
        int end = start = this._fcMin + this._ccpText + this._ccpFtn;
        int arrayIndex = 0;
        switch (type) {
            case 1: {
                arrayIndex = HEADER_EVEN_INDEX + index * 6;
                break;
            }
            case 3: {
                arrayIndex = FOOTER_EVEN_INDEX + index * 6;
                break;
            }
            case 2: {
                arrayIndex = HEADER_ODD_INDEX + index * 6;
                break;
            }
            case 4: {
                arrayIndex = FOOTER_ODD_INDEX + index * 6;
                break;
            }
            case 5: {
                arrayIndex = HEADER_FIRST_INDEX + index * 6;
                break;
            }
            case 6: {
                arrayIndex = FOOTER_FIRST_INDEX + index * 6;
            }
        }
        HeaderFooter retValue = new HeaderFooter(type, start += LittleEndian.getInt(this._tableStream, this._hdrOffset + arrayIndex * 4), end += LittleEndian.getInt(this._tableStream, this._hdrOffset + (arrayIndex + 1) * 4));
        if (end - start == 0 && index > 1) {
            retValue = this.createSectionHdrFtr(type, index - 1);
        }
        return retValue;
    }
}

