/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.deployer.ExternalComponentDeployerProvider;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class ComponentTagHandlerTest
extends TestCase {
    private static final String PATH = "org/seasar/framework/container/factory/ComponentTagHandlerTest.dicon";

    public void testComponent() throws Exception {
        S2Container container = S2ContainerFactory.create((String)PATH);
        ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)new ExternalComponentDeployerProvider());
        MockServletContextImpl ctx = new MockServletContextImpl("s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setRequest((Object)request);
        extCtx.setApplication((Object)ctx);
        container.setExternalContext((ExternalContext)extCtx);
        container.init();
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)List.class));
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)"aaa"));
        ComponentTagHandlerTest.assertEquals((Object)new Integer(1), (Object)container.getComponent((Object)"bbb"));
        ComponentTagHandlerTest.assertEquals((boolean)true, (container.getComponent((Object)"ccc") != container.getComponent((Object)"ccc") ? 1 : 0) != 0);
        ComponentDef cd = container.getComponentDef((Object)"ddd");
        ComponentTagHandlerTest.assertEquals((Object)AutoBindingDefFactory.NONE, (Object)cd.getAutoBindingDef());
        HashMap map = new HashMap();
        container.injectDependency(map, "eee");
        ComponentTagHandlerTest.assertEquals((Object)"111", map.get("aaa"));
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)"fff"));
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)"ggg"));
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)"hhh"));
        ComponentTagHandlerTest.assertNotNull((Object)container.getComponent((Object)"iii"));
        ComponentTagHandlerTest.assertEquals((Object)"jjj", (Object)container.getComponent((Object)"jjj"));
        request.setAttribute("name", (Object)"aaa");
        cd = container.getComponentDef((Object)"kkk");
        ComponentTagHandlerTest.assertEquals((boolean)true, (boolean)cd.isExternalBinding());
        Kkk kkk = (Kkk)cd.getComponent();
        ComponentTagHandlerTest.assertEquals((String)"aaa", (String)kkk.getName());
    }

    public static class Kkk {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

