/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.aop.javassist.AspectWeaver;

public class AspectWeaverTest
extends TestCase {
    public void testGetEnhancedClassName() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Object.class, null);
        String name1 = weaver.getEnhancedClassName();
        AspectWeaverTest.assertTrue((String)"1", (boolean)name1.startsWith("$$java.lang.Object$$EnhancedByS2AOP$$"));
        AspectWeaverTest.assertTrue((String)"2", (boolean)name1.endsWith("_0"));
        String name2 = weaver.getEnhancedClassName();
        AspectWeaverTest.assertTrue((String)"3", (boolean)name2.startsWith("$$java.lang.Object$$EnhancedByS2AOP$$"));
        AspectWeaverTest.assertTrue((String)"4", (boolean)name2.endsWith("_1"));
        weaver = new AspectWeaver(AspectWeaverTest.class, null);
        String name3 = weaver.getEnhancedClassName();
        AspectWeaverTest.assertTrue((String)"5", (boolean)name3.startsWith("org.seasar.framework.aop.javassist.AspectWeaverTest$$EnhancedByS2AOP$$"));
        AspectWeaverTest.assertTrue((String)"6", (boolean)name3.endsWith("_0"));
    }

    public void testGetMethodInvocationClassName() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Object.class, null);
        String name1 = weaver.getMethodInvocationClassName(Object.class.getMethod("hashCode", null));
        AspectWeaverTest.assertTrue((String)"1", (boolean)name1.startsWith("$$java.lang.Object$$EnhancedByS2AOP$$"));
        AspectWeaverTest.assertTrue((String)"2", (boolean)name1.endsWith("hashCode$$0"));
    }

    public void testSetInterceptor() throws Exception {
        AspectWeaver weaver = new AspectWeaver(OrdinalMethods.class, null);
        for (int i = 1; i <= 10; ++i) {
            weaver.setInterceptors((class$org$seasar$framework$aop$javassist$AspectWeaverTest$OrdinalMethods == null ? AspectWeaverTest.class$("org.seasar.framework.aop.javassist.AspectWeaverTest$OrdinalMethods") : class$org$seasar$framework$aop$javassist$AspectWeaverTest$OrdinalMethods).getMethod("test" + i, null), new MethodInterceptor[0]);
        }
        weaver.setInterceptors(OrdinalMethods.class.getMethod("test", null), new MethodInterceptor[0]);
    }

    public void testGenerateFromInterface() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Runnable.class, null);
        weaver.setInterceptors(Runnable.class.getDeclaredMethod("run", null), new MethodInterceptor[0]);
        Class clazz = weaver.generateClass();
        clazz.getDeclaredMethod("run", null);
        try {
            clazz.getDeclaredMethod("run$$invokeSuperMethod$$", null);
            AspectWeaverTest.fail((String)"3");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGenerateFromConcreteClass() throws Exception {
        AspectWeaver weaver = new AspectWeaver(ArrayList.class, null);
        weaver.setInterceptors(ArrayList.class.getDeclaredMethod("size", null), new MethodInterceptor[0]);
        Class clazz = weaver.generateClass();
        clazz.getDeclaredMethod("size", null);
        clazz.getDeclaredMethod("$$size$$invokeSuperMethod$$", null);
    }

    public void testGenerateFromAbstractClass() throws Exception {
        AspectWeaver weaver = new AspectWeaver(AbstractList.class, null);
        weaver.setInterceptors(AbstractList.class.getDeclaredMethod("clear", null), new MethodInterceptor[0]);
        weaver.setInterceptors(List.class.getDeclaredMethod("size", null), new MethodInterceptor[0]);
        Class clazz = weaver.generateClass();
        clazz.getDeclaredMethod("clear", null);
        clazz.getDeclaredMethod("$$clear$$invokeSuperMethod$$", null);
        clazz.getDeclaredMethod("size", null);
        try {
            clazz.getDeclaredMethod("size$$invokeSuperMethod$$", null);
            AspectWeaverTest.fail((String)"3");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testInterType() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Foo.class, null);
        weaver.setInterTypes(new InterType[]{new FieldInterType()});
        Class clazz = weaver.generateClass();
        AspectWeaverTest.assertNotNull((String)"1", (Object)clazz.getDeclaredField("test"));
    }

    public void testReturnNumber() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Collection.class, null);
        weaver.setInterceptors(Collection.class.getDeclaredMethod("size", null), new MethodInterceptor[]{new ReturnBigDecimalInterceptor()});
        Class clazz = weaver.generateClass();
        Collection coll = (Collection)clazz.newInstance();
        AspectWeaverTest.assertEquals((String)"1", (int)100, (int)coll.size());
    }

    public void testReturnNumberNull() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Collection.class, null);
        weaver.setInterceptors(Collection.class.getDeclaredMethod("size", null), new MethodInterceptor[]{new ReturnNullInterceptor()});
        Class clazz = weaver.generateClass();
        Collection coll = (Collection)clazz.newInstance();
        AspectWeaverTest.assertEquals((String)"1", (int)0, (int)coll.size());
    }

    public void testReturnBooleanNull() throws Exception {
        AspectWeaver weaver = new AspectWeaver(Collection.class, null);
        weaver.setInterceptors(Collection.class.getDeclaredMethod("isEmpty", null), new MethodInterceptor[]{new ReturnNullInterceptor()});
        Class clazz = weaver.generateClass();
        Collection coll = (Collection)clazz.newInstance();
        AspectWeaverTest.assertFalse((String)"1", (boolean)coll.isEmpty());
    }

    public static class OrdinalMethods {
        public void test1() {
        }

        public void test2() {
        }

        public void test3() {
        }

        public void test4() {
        }

        public void test5() {
        }

        public void test6() {
        }

        public void test7() {
        }

        public void test8() {
        }

        public void test9() {
        }

        public void test10() {
        }

        public void test() {
        }
    }

    public static class FieldInterType
    implements InterType {
        public void introduce(Class targetClass, CtClass enhancedClass) {
            try {
                enhancedClass.addField(new CtField(CtClass.booleanType, "test", enhancedClass));
            }
            catch (CannotCompileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ReturnNullInterceptor
    extends AbstractInterceptor {
        private static final long serialVersionUID = 4724885819473955866L;

        public Object invoke(MethodInvocation arg0) throws Throwable {
            return null;
        }
    }

    public static class ReturnBigDecimalInterceptor
    extends AbstractInterceptor {
        private static final long serialVersionUID = -3444509695408031219L;

        public Object invoke(MethodInvocation arg0) throws Throwable {
            return new BigDecimal("100");
        }
    }

    public static class Foo {
    }
}

