/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.HashSet;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.AccessTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AbstractPropertyAssembler;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;

public class AutoPropertyAssembler
extends AbstractPropertyAssembler {
    public AutoPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public void assemble(Object component) {
        int i;
        if (component == null) {
            return;
        }
        BeanDesc beanDesc = this.getBeanDesc(component);
        ComponentDef cd = this.getComponentDef();
        int size = cd.getPropertyDefSize();
        HashSet<String> names = new HashSet<String>();
        for (i = 0; i < size; ++i) {
            PropertyDef propDef = cd.getPropertyDef(i);
            AccessTypeDef accessTypeDef = propDef.getAccessTypeDef();
            accessTypeDef.bind(cd, propDef, component);
            String propName = propDef.getPropertyName();
            names.add(propName);
        }
        if (cd.isExternalBinding()) {
            this.bindExternally(beanDesc, cd, component, names);
        }
        size = beanDesc.getPropertyDescSize();
        for (i = 0; i < size; ++i) {
            PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
            String propName = propDesc.getPropertyName();
            if (names.contains(propName)) continue;
            BindingTypeDefFactory.getBindingTypeDef("should").bind(this.getComponentDef(), null, propDesc, component);
        }
    }
}

