/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;

public class TimeType
extends AbstractSqlType {
    public TimeType() {
        this("time");
    }

    public TimeType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 92);
        } else {
            ps.setTime(index, this.toTime(value));
        }
    }

    protected Time toTime(String value) {
        return TimeConversionUtil.toTime((String)value, (String)"HH:mm:ss");
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Time value = resultSet.getTime(index);
        return value != null ? this.toString(value) : null;
    }

    protected String toString(Time value) {
        return StringConversionUtil.toString((Date)value, (String)"HH:mm:ss");
    }
}

