/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Array;
import java.util.List;
import junit.framework.TestCase;
import junitx.framework.ArrayAssert;
import org.seasar.framework.util.ArrayUtil;

public class ArrayUtilTest
extends TestCase {
    public void testAdd() throws Exception {
        Object[] array = new String[]{"111"};
        String[] newArray = (String[])ArrayUtil.add((Object[])array, (Object)"222");
        ArrayUtilTest.assertEquals((String)"1", (int)2, (int)newArray.length);
        ArrayUtilTest.assertEquals((String)"2", (String)"111", (String)newArray[0]);
        ArrayUtilTest.assertEquals((String)"3", (String)"222", (String)newArray[1]);
    }

    public void testAdd2() throws Exception {
        Object[] a = new String[]{"1", "2"};
        Object[] b = new String[]{"3"};
        a = (String[])ArrayUtil.add((Object[])a, (Object[])b);
        ArrayUtilTest.assertEquals((String)"1", (int)3, (int)a.length);
        ArrayUtilTest.assertEquals((String)"2", (String)"1", (String)a[0]);
        ArrayUtilTest.assertEquals((String)"3", (String)"2", (String)a[1]);
        ArrayUtilTest.assertEquals((String)"4", (String)"3", (String)a[2]);
    }

    public void testAdd_int() throws Exception {
        int[] array = new int[]{1};
        int[] newArray = ArrayUtil.add((int[])array, (int)2);
        ArrayUtilTest.assertEquals((int)2, (int)newArray.length);
        ArrayUtilTest.assertEquals((int)1, (int)newArray[0]);
        ArrayUtilTest.assertEquals((int)2, (int)newArray[1]);
    }

    public void testIndexOf() throws Exception {
        Object[] array = new String[]{"111", "222", "333"};
        ArrayUtilTest.assertEquals((String)"1", (int)1, (int)ArrayUtil.indexOf((Object[])array, (Object)"222"));
        ArrayUtilTest.assertEquals((String)"2", (int)-1, (int)ArrayUtil.indexOf((Object[])array, (Object)new Object()));
        ArrayUtilTest.assertEquals((String)"3", (int)-1, (int)ArrayUtil.indexOf((Object[])array, null));
        array[1] = null;
        ArrayUtilTest.assertEquals((String)"4", (int)1, (int)ArrayUtil.indexOf((Object[])array, null));
    }

    public void testIndexOf_character() throws Exception {
        char[] array = new char[]{'a', 'b', 'c'};
        ArrayUtilTest.assertEquals((String)"1", (int)0, (int)ArrayUtil.indexOf((char[])array, (char)'a'));
        ArrayUtilTest.assertEquals((String)"2", (int)-1, (int)ArrayUtil.indexOf((char[])array, (char)'d'));
    }

    public void testRemoveFirst() throws Exception {
        Object[] array = new String[]{"111", "222", "333"};
        String[] newArray = (String[])ArrayUtil.remove((Object[])array, (Object)"111");
        ArrayUtilTest.assertEquals((String)"1", (int)2, (int)newArray.length);
        ArrayUtilTest.assertEquals((String)"2", (String)"222", (String)newArray[0]);
        ArrayUtilTest.assertEquals((String)"3", (String)"333", (String)newArray[1]);
    }

    public void testRemoveMiddle() throws Exception {
        Object[] array = new String[]{"111", "222", "333"};
        String[] newArray = (String[])ArrayUtil.remove((Object[])array, (Object)"222");
        ArrayUtilTest.assertEquals((String)"1", (int)2, (int)newArray.length);
        ArrayUtilTest.assertEquals((String)"2", (String)"111", (String)newArray[0]);
        ArrayUtilTest.assertEquals((String)"3", (String)"333", (String)newArray[1]);
    }

    public void testRemoveLast() throws Exception {
        Object[] array = new String[]{"111", "222", "333"};
        String[] newArray = (String[])ArrayUtil.remove((Object[])array, (Object)"333");
        ArrayUtilTest.assertEquals((String)"1", (int)2, (int)newArray.length);
        ArrayUtilTest.assertEquals((String)"2", (String)"111", (String)newArray[0]);
        ArrayUtilTest.assertEquals((String)"3", (String)"222", (String)newArray[1]);
    }

    public void testRemoveNothing() throws Exception {
        Object[] array = new String[]{"111", "222", "333"};
        String[] newArray = (String[])ArrayUtil.remove((Object[])array, (Object)"444");
        ArrayUtilTest.assertSame((String)"1", (Object)array, (Object)newArray);
    }

    public void testIsEmpty() {
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.isEmpty(null));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.isEmpty((Object[])new Object[0]));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.isEmpty((Object[])new Object[]{""}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.isEmpty((Object[])new Object[]{"aaa"}));
    }

    public void testContains() throws Exception {
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.contains((Object[])new Object[]{"1"}, (Object)"1"));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.contains((Object[])new Object[]{"1"}, (Object)"2"));
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.contains((Object[])new Object[]{"2", "1"}, (Object)"1"));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.contains((Object[])null, (Object)"1"));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.contains((Object[])null, null));
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.contains((Object[])new Object[]{null}, null));
    }

    public void testContains_character() throws Exception {
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.contains((char[])new char[]{'1', '2'}, (char)'1'));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.contains((char[])new char[]{'1'}, (char)'2'));
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.contains((char[])new char[]{'2', '1'}, (char)'1'));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.contains((char[])null, (char)'1'));
    }

    public void testEqualsIgnoreSequence() throws Exception {
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.equalsIgnoreSequence((Object[])new Object[]{"1"}, (Object[])new Object[]{"1"}));
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.equalsIgnoreSequence((Object[])new Object[]{"1", "2", "3"}, (Object[])new Object[]{"2", "3", "1"}));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.equalsIgnoreSequence((Object[])new Object[]{"1"}, (Object[])new Object[]{"2"}));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.equalsIgnoreSequence((Object[])new Object[]{"1"}, (Object[])new Object[0]));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.equalsIgnoreSequence((Object[])new Object[]{new Integer("1")}, (Object[])new Object[]{"1"}));
        ArrayUtilTest.assertEquals((boolean)true, (boolean)ArrayUtil.equalsIgnoreSequence(null, null));
        ArrayUtilTest.assertEquals((boolean)false, (boolean)ArrayUtil.equalsIgnoreSequence(null, (Object[])new Object[0]));
    }

    public void testSetArrayValue() throws Exception {
        Object o = Array.newInstance(Integer.TYPE, 3);
        ArrayUtil.setArrayValue((Object)o, Integer.TYPE, (Object)new Integer(1), (int)0);
        ArrayUtil.setArrayValue((Object)o, Integer.TYPE, (Object)new Integer(2), (int)1);
        ArrayUtil.setArrayValue((Object)o, Integer.TYPE, (Object)new Integer(3), (int)2);
        int[] num = (int[])o;
        ArrayAssert.assertEquals((int[])new int[]{1, 2, 3}, (int[])num);
    }

    public void testToObjectArray() throws Exception {
        Object[] a = ArrayUtil.toObjectArray((Object)new int[]{1, 5, 2});
        ArrayAssert.assertEquals((Object[])new Integer[]{new Integer(1), new Integer(5), new Integer(2)}, (Object[])a);
    }

    public void testToObjectArray_NoArray() throws Exception {
        try {
            ArrayUtil.toObjectArray((Object)"a");
            ArrayUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToList() throws Exception {
        int[] a = new int[]{1, 5};
        List list = ArrayUtil.toList((Object)a);
        ArrayUtilTest.assertEquals((Object)new Integer(1), list.get(0));
        ArrayUtilTest.assertEquals((Object)new Integer(5), list.get(1));
    }
}

