/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    private static final HsqlTimer timer;

    public static Vector getDatabaseURIs() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = databaseIDMap.values().iterator();
        while (iterator.hasNext()) {
            Database database = (Database)iterator.next();
            vector.addElement(database.getURI());
        }
        return vector;
    }

    public static void closeDatabases(int n) {
        Iterator iterator = databaseIDMap.values().iterator();
        while (iterator.hasNext()) {
            Database database = (Database)iterator.next();
            try {
                database.close(n);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    static Session newSession(int n, String string, String string2) throws HsqlException {
        Database database = (Database)databaseIDMap.get(n);
        return database.connect(string, string2);
    }

    public static Session newSession(String string, String string2, String string3, String string4, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        return database.connect(string3, string4);
    }

    static Session getSession(String string, String string2, int n) throws HsqlException {
        if (string2 == null) {
            return null;
        }
        Database database = DatabaseManager.lookupDatabaseObject(string, string2);
        return database.sessionManager.getSession(n);
    }

    static int getDatabase(String string, String string2, Server server, HsqlProperties hsqlProperties) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        DatabaseManager.registerServer(server, database);
        return database.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        Database database;
        Database database2 = database = DatabaseManager.getDatabaseObject(string, string2, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(string, string2) == null) {
                        DatabaseManager.addDatabaseObject(string, string2, database);
                    }
                    database.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107);
                }
            }
        }
        return database;
    }

    private static synchronized Database getDatabaseObject(String string, String string2, HsqlProperties hsqlProperties) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == "res:" ? resDatabaseMap : memDatabaseMap;
        }
        Database database = (Database)hashMap.get(object);
        if (database == null) {
            database = new Database(string, string2, string + object, hsqlProperties);
            database.databaseID = dbIDCounter;
            databaseIDMap.put(dbIDCounter, database);
            ++dbIDCounter;
            hashMap.put(object, database);
        }
        return database;
    }

    private static synchronized Database lookupDatabaseObject(String string, String string2) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == "res:" ? resDatabaseMap : memDatabaseMap;
        }
        return (Database)hashMap.get(object);
    }

    private static synchronized void addDatabaseObject(String string, String string2, Database database) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == "file:") {
            hashMap = fileDatabaseMap;
            object = DatabaseManager.filePathToKey(string2);
        } else {
            hashMap = string == "res:" ? resDatabaseMap : memDatabaseMap;
        }
        databaseIDMap.put(database.databaseID, database);
        hashMap.put(object, database);
    }

    static void removeDatabase(Database database) {
        HashMap hashMap;
        Object object;
        int n;
        block7: {
            n = database.databaseID;
            String string = database.getType();
            String string2 = database.getPath();
            object = string2;
            DatabaseManager.notifyServers(database);
            if (string == "file:") {
                hashMap = fileDatabaseMap;
                try {
                    object = DatabaseManager.filePathToKey(string2);
                }
                catch (HsqlException hsqlException) {
                    Iterator iterator = hashMap.keySet().iterator();
                    Object object2 = null;
                    while (iterator.hasNext()) {
                        Object object3 = iterator.next();
                        if (hashMap.get(object3) != database) continue;
                        object2 = object3;
                        break;
                    }
                    if (object2 == null) {
                        hsqlException.printStackTrace();
                        break block7;
                    }
                    object = object2;
                }
            } else {
                hashMap = string == "res:" ? resDatabaseMap : memDatabaseMap;
            }
        }
        databaseIDMap.remove(n);
        hashMap.remove(object);
        if (databaseIDMap.isEmpty()) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database database) {
        Iterator iterator = serverMap.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            hashSet.remove(database);
            if (!hashSet.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static void registerServer(Server server, Database database) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet hashSet = (HashSet)serverMap.get(server);
        hashSet.add(database);
    }

    private static void notifyServers(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            server.notify(0, database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static Object filePathToKey(String string) throws HsqlException {
        try {
            return FileUtil.canonicalFile(string);
        }
        catch (Exception exception) {
            throw Trace.error(29, exception.toString());
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

