/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import java.io.File;

import org.seasar.extension.jdbc.gen.internal.util.ArgumentUtil;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.framework.util.StringUtil;

/**
 * {@link File}を扱う{@link ArgumentType}の実装クラスです。
 * 
 * @author taedium
 */
public class FileType implements ArgumentType<File> {

    public File toObject(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        String s = ArgumentUtil.decode(value);
        return new File(s);
    }

    public String toText(File value) {
        if (value == null) {
            return "";
        }
        String path = FileUtil.getCanonicalPath(value);
        return ArgumentUtil.encode(path);
    }

}
