/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.ShortConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class SmallIntType
extends AbstractSqlType {
    public SmallIntType() {
        this("smallint");
    }

    public SmallIntType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 5);
        } else {
            ps.setShort(index, ShortConversionUtil.toPrimitiveShort((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Object value = resultSet.getObject(index);
        return value != null ? StringConversionUtil.toString((Object)value) : null;
    }
}

