/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.CPStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.io.StorageFile;

class CPFile
extends InputStreamFile {
    private final CPStorageFactory storageFactory;

    CPFile(CPStorageFactory cPStorageFactory, String string) {
        super(cPStorageFactory, string);
        this.storageFactory = cPStorageFactory;
    }

    CPFile(CPStorageFactory cPStorageFactory, String string, String string2) {
        super((BaseStorageFactory)cPStorageFactory, string, string2);
        this.storageFactory = cPStorageFactory;
    }

    CPFile(CPFile cPFile, String string) {
        super(cPFile, string);
        this.storageFactory = cPFile.storageFactory;
    }

    private CPFile(CPStorageFactory cPStorageFactory, String string, int n) {
        super((BaseStorageFactory)cPStorageFactory, string, n);
        this.storageFactory = cPStorageFactory;
    }

    public boolean exists() {
        return this.getURL() != null;
    }

    StorageFile getParentDir(int n) {
        return new CPFile(this.storageFactory, this.path, n);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(this.path);
        }
        if (inputStream == null) {
            classLoader = this.getClass().getClassLoader();
            inputStream = classLoader != null ? classLoader.getResourceAsStream(this.path) : ClassLoader.getSystemResourceAsStream(this.path);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(this.toString());
        }
        return inputStream;
    }

    public URL getURL() {
        URL uRL;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (uRL = classLoader.getResource(this.path)) != null) {
            return uRL;
        }
        classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResource(this.path);
        }
        return ClassLoader.getSystemResource(this.path);
    }
}

