create table department(department_id integer not null primary key, department_no integer not null,department_name varchar(20),location varchar(20) default 'tokyo', version integer);
create table address(address_id integer not null primary key, street varchar(20), version integer);
create table employee(employee_id integer not null primary key, employee_no integer not null ,employee_name varchar(20),manager_id integer,hiredate date,salary numeric(7,2),department_id integer,address_id integer,version integer, constraint fk_department_id foreign key(department_id) references department(department_id), constraint fk_address_id foreign key(address_id) references address(address_id));
create table comp_key_department(department_id1 integer not null, department_id2 integer not null, department_no integer not null,department_name varchar(20),location varchar(20) default 'tokyo', version integer, constraint pk_comp_key_department primary key(department_id1, department_id2));
create table comp_key_address(address_id1 integer not null, address_id2 integer not null, street varchar(20), version integer, constraint pk_comp_key_address primary key(address_id1, address_id2));
create table comp_key_employee(employee_id1 integer not null, employee_id2 integer not null, employee_no integer not null ,employee_name varchar(20),manager_id1 integer,manager_id2 integer,hiredate date,salary numeric(7,2),department_id1 integer,department_id2 integer,address_id1 integer,address_id2 integer,version integer, constraint pk_comp_key_employee primary key(employee_id1, employee_id2), constraint fk_comp_key_department_id foreign key(department_id1, department_id2) references comp_key_department(department_id1, department_id2), constraint fk_comp_key_address_id foreign key(address_id1, address_id2) references comp_key_address(address_id1, address_id2));
alter table department add constraint department_uk1 unique(department_no);
alter table comp_key_department add constraint comp_key_department_uk1 unique(department_no);
alter table employee add constraint employee_uk1 unique(address_id);
alter table comp_key_employee add constraint comp_key_employee_uk1 unique(address_id1, address_id2);
create table category(id integer not null primary key, name varchar(20));
create table product(id integer not null primary key, primary_category_id integer not null, secondary_category_id integer not null, constraint product_fk1 foreign key(primary_category_id) references category(id), constraint product_fk2 foreign key(secondary_category_id) references category(id));
create table product2(id integer not null primary key, category integer not null, constraint product2_fk1 foreign key(category) references category(id));

-- supported
create table integer_table (integer_column integer);
create table int_table (int_column int);
create table double_table (double_column double);
create table double_precision_table (double_precision_column double precision);
create table float_table (float_column float);
create table varchar_table (varchar_column varchar);
create table varchar_ignorecase_table (varchar_ignorecase_column varchar_ignorecase);
create table char_table (char_column char);
create table character_table (character_column character);
create table longvarchar_table (longvarchar_column longvarchar);
create table date_table (date_column date);
create table time_table (time_column time);
create table timestamp_table (timestamp_column timestamp);
create table datetime_table (datetime_column datetime);
create table decimal_table (decimal_column decimal);
create table numeric_table (numeric_column numeric);
create table boolean_table (boolean_column boolean);
create table bit_table (bit_column bit);
create table tinyint_table (tinyint_column tinyint);
create table smallint_table (smallint_column smallint);
create table bigint_table (bigint_column bigint);
create table real_table (real_column real);
create table varbinary_table (varbinary_column varbinary);
create table longvarbinary_table (longvarbinary_column longvarbinary);
create table テーブル (カラム varchar(255));