/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.postgresql.core.BaseConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AbstractJdbc2BlobClob {
    protected BaseConnection conn;
    protected LargeObject lo;
    private ArrayList subLOs;

    public AbstractJdbc2BlobClob(BaseConnection conn, long oid) throws SQLException {
        this.conn = conn;
        LargeObjectManager lom = conn.getLargeObjectAPI();
        this.lo = lom.open(oid);
        this.subLOs = new ArrayList();
    }

    public synchronized void free() throws SQLException {
        if (this.lo != null) {
            this.lo.close();
            this.lo = null;
        }
        Iterator i = this.subLOs.iterator();
        while (i.hasNext()) {
            LargeObject subLO = (LargeObject)i.next();
            subLO.close();
        }
        this.subLOs = null;
    }

    public synchronized void truncate(long len) throws SQLException {
        this.checkFreed();
        if (!this.conn.haveMinimumServerVersion("8.3")) {
            throw new PSQLException(GT.tr("Truncation of large objects is only implemented in 8.3 and later servers."), PSQLState.NOT_IMPLEMENTED);
        }
        this.assertPosition(len);
        this.lo.truncate((int)len);
    }

    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.lo.size();
    }

    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.assertPosition(pos);
        this.lo.seek((int)(pos - 1L), 0);
        return this.lo.read(length);
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        LargeObject subLO = this.lo.copy();
        this.subLOs.add(subLO);
        subLO.seek(0, 0);
        return subLO.getInputStream();
    }

    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        this.assertPosition(pos);
        LargeObject subLO = this.lo.copy();
        this.subLOs.add(subLO);
        subLO.seek((int)(pos - 1L));
        return subLO.getOutputStream();
    }

    public synchronized long position(byte[] pattern, long start) throws SQLException {
        this.assertPosition(start, pattern.length);
        int position = 1;
        int patternIdx = 0;
        long result = -1L;
        int tmpPosition = 1;
        LOIterator i = new LOIterator(start - 1L);
        while (i.hasNext()) {
            byte b = i.next();
            if (b == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    tmpPosition = position;
                }
                if (++patternIdx == pattern.length) {
                    result = tmpPosition;
                    break;
                }
            } else {
                patternIdx = 0;
            }
            ++position;
        }
        return result;
    }

    public synchronized long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    protected void assertPosition(long pos) throws SQLException {
        this.assertPosition(pos, 0L);
    }

    protected void assertPosition(long pos, long len) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", new Integer(Integer.MAX_VALUE)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkFreed() throws SQLException {
        if (this.lo == null) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously"), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private class LOIterator {
        private static final int BUFFER_SIZE = 8096;
        private byte[] buffer = new byte[8096];
        private int idx = 8096;
        private int numBytes = 8096;

        public LOIterator(long start) throws SQLException {
            AbstractJdbc2BlobClob.this.lo.seek((int)start);
        }

        public boolean hasNext() throws SQLException {
            boolean result = false;
            if (this.idx < this.numBytes) {
                result = true;
            } else {
                this.numBytes = AbstractJdbc2BlobClob.this.lo.read(this.buffer, 0, 8096);
                this.idx = 0;
                result = this.numBytes > 0;
            }
            return result;
        }

        private byte next() {
            return this.buffer[this.idx++];
        }
    }
}

