/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.AutoLength;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Numeric;

public class LengthProperty
extends Property {
    private Length length;

    public LengthProperty(Length length) {
        this.length = length;
    }

    public Length getLength() {
        return this.length;
    }

    public Numeric getNumeric() {
        return this.length.asNumeric();
    }

    public Object getObject() {
        return this.length;
    }

    public static class Maker
    extends Property.Maker {
        public Maker(String name) {
            super(name);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws FOPException {
            String pval;
            if (this.isAutoLengthAllowed() && (pval = p.getString()) != null && pval.equals("auto")) {
                return new LengthProperty(new AutoLength());
            }
            if (p instanceof LengthProperty) {
                return p;
            }
            Length val = p.getLength();
            if (val != null) {
                return new LengthProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }

        protected boolean isAutoLengthAllowed() {
            return false;
        }
    }
}

