/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class Analyze
extends DefineCommand {
    private int sampleRows = 10000;

    public Analyze(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        ObjectArray objectArray = database.getAllSchemaObjects(0);
        for (int i = 0; i < objectArray.size(); ++i) {
            Table table = (Table)objectArray.get(i);
            if (!(table instanceof TableData)) continue;
            Column[] columnArray = table.getColumns();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT ");
            for (int j = 0; j < columnArray.length; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("SELECTIVITY(");
                stringBuffer.append(columnArray[j].getSQL());
                stringBuffer.append(")");
            }
            stringBuffer.append(" FROM ");
            stringBuffer.append(table.getSQL());
            if (this.sampleRows > 0) {
                stringBuffer.append(" LIMIT 1 SAMPLE_SIZE ");
                stringBuffer.append(this.sampleRows);
            }
            String string = stringBuffer.toString();
            Prepared prepared = this.session.prepare(string);
            LocalResult localResult = prepared.query(0);
            localResult.next();
            for (int j = 0; j < columnArray.length; ++j) {
                int n = localResult.currentRow()[j].getInt();
                columnArray[j].setSelectivity(n);
            }
            database.update(this.session, table);
        }
        return 0;
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }
}

