/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class DateType
extends AbstractSqlType {
    public DateType() {
        this("date");
    }

    public DateType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 91);
        } else {
            String pattern = null;
            pattern = value.contains("-") ? "yyyy-MM-dd" : "yyyy/MM/dd";
            ps.setDate(index, SqlDateConversionUtil.toDate((Object)value, (String)pattern));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        java.sql.Date value = resultSet.getDate(index);
        return value != null ? StringConversionUtil.toString((Date)value, (String)"yyyy/MM/dd") : null;
    }
}

