/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.ResultColumn;
import org.h2.server.TcpServer;
import org.h2.util.ObjectArray;
import org.h2.util.SmallMap;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class TcpServerThread
implements Runnable {
    private TcpServer server;
    private Session session;
    private boolean stop;
    private Thread thread;
    private Transfer transfer;
    private Command commit;
    private SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);

    public TcpServerThread(Socket socket, TcpServer server) {
        this.server = server;
        this.transfer = new Transfer(null);
        this.transfer.setSocket(socket);
    }

    private void log(String s) {
        this.server.log(this + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.transfer.init();
            this.log("Connect");
            try {
                int version = this.transfer.readInt();
                if (!this.server.allow(this.transfer.getSocket())) {
                    throw Message.getSQLException(90117);
                }
                if (version != 4) {
                    throw Message.getSQLException(90047, new String[]{"" + version, "4"});
                }
                String db = this.transfer.readString();
                String originalURL = this.transfer.readString();
                String baseDir = this.server.getBaseDir();
                if (baseDir == null) {
                    baseDir = SysProperties.getBaseDir();
                }
                ConnectionInfo ci = new ConnectionInfo(db);
                if (baseDir != null) {
                    ci.setBaseDir(baseDir);
                }
                if (this.server.getIfExists()) {
                    ci.setProperty("IFEXISTS", "TRUE");
                }
                ci.setOriginalURL(originalURL);
                ci.setUserName(this.transfer.readString());
                ci.setUserPasswordHash(this.transfer.readBytes());
                ci.setFilePasswordHash(this.transfer.readBytes());
                int len = this.transfer.readInt();
                for (int i = 0; i < len; ++i) {
                    ci.setProperty(this.transfer.readString(), this.transfer.readString());
                }
                Engine engine = Engine.getInstance();
                this.session = engine.getSession(ci);
                this.transfer.setSession(this.session);
                this.transfer.writeInt(1).flush();
                this.log("Connected");
            }
            catch (Throwable e) {
                this.sendError(e);
                this.stop = true;
            }
            while (!this.stop) {
                try {
                    this.process();
                }
                catch (Throwable e) {
                    this.sendError(e);
                }
            }
            this.log("Disconnect");
        }
        catch (Throwable e) {
            this.server.logError(e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session != null) {
            try {
                Command rollback = this.session.prepareLocal("ROLLBACK");
                rollback.executeUpdate();
                this.session.close();
            }
            catch (Exception e) {
                this.server.logError(e);
            }
            finally {
                this.session = null;
            }
        }
    }

    public void close() {
        try {
            this.stop = true;
            this.closeSession();
            this.transfer.close();
            this.log("Close");
        }
        catch (Exception e) {
            this.server.logError(e);
        }
        this.server.remove(this);
    }

    private void sendError(Throwable e) {
        try {
            String sql;
            String message;
            SQLException s = Message.convert(e);
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            if (e instanceof JdbcSQLException) {
                JdbcSQLException j = (JdbcSQLException)e;
                message = j.getOriginalMessage();
                sql = j.getSQL();
            } else {
                message = e.getMessage();
                sql = null;
            }
            this.transfer.writeInt(0).writeString(s.getSQLState()).writeString(message).writeString(sql).writeInt(s.getErrorCode()).writeString(trace).flush();
        }
        catch (IOException e2) {
            this.server.logError(e2);
            this.stop = true;
        }
    }

    private void setParameters(Command command) throws IOException, SQLException {
        int len = this.transfer.readInt();
        ObjectArray params = command.getParameters();
        for (int i = 0; i < len; ++i) {
            Parameter p = (Parameter)params.get(i);
            p.setValue(this.transfer.readValue());
        }
    }

    private void process() throws IOException, SQLException {
        int operation = this.transfer.readInt();
        switch (operation) {
            case 0: {
                int id = this.transfer.readInt();
                String sql = this.transfer.readString();
                Command command = this.session.prepareLocal(sql);
                boolean readonly = command.isReadOnly();
                this.cache.addObject(id, command);
                boolean isQuery = command.isQuery();
                int paramCount = command.getParameters().size();
                this.transfer.writeInt(1).writeBoolean(isQuery).writeBoolean(readonly).writeInt(paramCount).flush();
                break;
            }
            case 1: {
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = this.session.prepareLocal("COMMIT");
                }
                this.commit.executeUpdate();
                this.transfer.writeInt(1).flush();
                break;
            }
            case 10: {
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                LocalResult result = command.getMetaDataLocal();
                this.cache.addObject(objectId, result);
                int columnCount = result.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(columnCount).writeInt(0);
                for (int i = 0; i < columnCount; ++i) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                int i;
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                int maxRows = this.transfer.readInt();
                int readRows = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                LocalResult result = command.executeQueryLocal(maxRows);
                this.cache.addObject(objectId, result);
                int columnCount = result.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(columnCount);
                int rowCount = result.getRowCount();
                this.transfer.writeInt(rowCount);
                for (i = 0; i < columnCount; ++i) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                }
                if (rowCount < readRows) {
                    for (i = 0; i <= rowCount; ++i) {
                        this.sendRow(result);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 3: {
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                int updateCount = command.executeUpdate();
                int status = 1;
                if (this.session.isClosed()) {
                    status = 2;
                }
                this.transfer.writeInt(status).writeInt(updateCount).writeBoolean(this.session.getAutoCommit());
                this.transfer.flush();
                break;
            }
            case 4: {
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(id);
                break;
            }
            case 5: {
                int id = this.transfer.readInt();
                LocalResult result = (LocalResult)this.cache.getObject(id, false);
                this.transfer.writeInt(1);
                this.sendRow(result);
                this.transfer.flush();
                break;
            }
            case 6: {
                int id = this.transfer.readInt();
                LocalResult result = (LocalResult)this.cache.getObject(id, false);
                result.reset();
                break;
            }
            case 7: {
                int id = this.transfer.readInt();
                LocalResult result = (LocalResult)this.cache.getObject(id, true);
                if (result == null) break;
                result.close();
                this.cache.freeObject(id);
                break;
            }
            case 9: {
                int oldId = this.transfer.readInt();
                int newId = this.transfer.readInt();
                Object obj = this.cache.getObject(oldId, false);
                this.cache.freeObject(oldId);
                this.cache.addObject(newId, obj);
                break;
            }
            default: {
                this.server.logInternalError("Unknown operation: " + operation);
                this.server.log("Unknown operation: " + operation);
                this.closeSession();
                this.close();
            }
        }
    }

    private void sendRow(LocalResult result) throws IOException, SQLException {
        boolean n = result.next();
        this.transfer.writeBoolean(n);
        if (n) {
            Value[] v = result.currentRow();
            for (int i = 0; i < result.getVisibleColumnCount(); ++i) {
                this.transfer.writeValue(v[i]);
            }
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }
}

