/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.constant.ErrorCode;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.InternalException;
import org.h2.message.TraceSystem;
import org.h2.util.Resources;
import org.h2.util.StringUtils;

public class Message {
    private static final Properties MESSAGES = new Properties();

    public static JdbcSQLException getSQLException(int sqlState, String p1) {
        return Message.getSQLException(sqlState, new String[]{p1});
    }

    public static String translate(String key, String[] param) {
        String message = MESSAGES.getProperty(key);
        if (message == null) {
            message = "(Message " + key + " not found)";
        }
        if (param != null) {
            Object[] o = param;
            message = MessageFormat.format(message, o);
        }
        return message;
    }

    public static JdbcSQLException getSQLException(int errorCode, String[] param, Throwable cause) {
        String sqlstate = ErrorCode.getState(errorCode);
        String message = Message.translate(sqlstate, param);
        return new JdbcSQLException(message, null, sqlstate, errorCode, cause, null);
    }

    public static JdbcSQLException getSQLException(int errorCode, String[] param) {
        return Message.getSQLException(errorCode, param, null);
    }

    public static SQLException getSyntaxError(String sql, int index) {
        sql = StringUtils.addAsterisk(sql, index);
        return Message.getSQLException(42000, sql);
    }

    public static SQLException getSyntaxError(String sql, int index, String expected) {
        sql = StringUtils.addAsterisk(sql, index);
        return Message.getSQLException(42001, new String[]{sql, expected});
    }

    public static JdbcSQLException getSQLException(int sqlstate) {
        return Message.getSQLException(sqlstate, (String)null);
    }

    public static JdbcSQLException getUnsupportedException() {
        return Message.getSQLException(50100);
    }

    public static JdbcSQLException getInvalidValueException(String value, String param) {
        return Message.getSQLException(90008, new String[]{value, param});
    }

    public static Error getInternalError(String s) {
        Error e = new Error(s);
        TraceSystem.traceThrowable(e);
        return e;
    }

    public static Error getInternalError(String s, Exception e) {
        Error e2 = new Error(s, e);
        TraceSystem.traceThrowable(e2);
        return e2;
    }

    public static SQLException addSQL(SQLException e, String sql) {
        if (e instanceof JdbcSQLException) {
            JdbcSQLException j = (JdbcSQLException)e;
            if (j.getSQL() == null) {
                j.setSQL(sql);
            }
            return j;
        }
        return new JdbcSQLException(e.getMessage(), sql, e.getSQLState(), e.getErrorCode(), e, null);
    }

    public static SQLException convert(Throwable e) {
        if (e instanceof InternalException) {
            e = ((InternalException)e).getOriginalCause();
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof InvocationTargetException) {
            InvocationTargetException te = (InvocationTargetException)e;
            Throwable t = te.getTargetException();
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            return Message.getSQLException(90105, null, e);
        }
        if (e instanceof IOException) {
            return Message.getSQLException(90028, new String[]{e.toString()}, e);
        }
        return Message.getSQLException(50000, new String[]{e.toString()}, e);
    }

    public static SQLException convertIOException(IOException e, String message) {
        if (message == null) {
            return Message.getSQLException(90028, new String[]{e.toString()}, e);
        }
        return Message.getSQLException(90031, new String[]{e.toString(), message}, e);
    }

    public static Error getInternalError() {
        return Message.getInternalError("unexpected code path");
    }

    public static InternalException convertToInternal(Exception e) {
        return new InternalException(e);
    }

    public static IOException convertToIOException(Throwable e) {
        JdbcSQLException e2;
        if (e instanceof JdbcSQLException && (e2 = (JdbcSQLException)e).getOriginalCause() != null) {
            e = e2.getOriginalCause();
        }
        IOException io = new IOException(e.toString());
        io.fillInStackTrace();
        return io;
    }

    static {
        try {
            byte[] translations;
            String language;
            byte[] messages = Resources.get("/org/h2/res/_messages_en.properties");
            if (messages != null) {
                MESSAGES.load(new ByteArrayInputStream(messages));
            }
            if (!"en".equals(language = Locale.getDefault().getLanguage()) && (translations = Resources.get("/org/h2/res/_messages_" + language + ".properties")) != null) {
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(translations));
                Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> e = it.next();
                    String key = (String)e.getKey();
                    MESSAGES.put(key, e.getValue() + "\n" + MESSAGES.getProperty(key));
                }
            }
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
    }
}

