/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.SVGPathContext;
import org.apache.batik.ext.awt.geom.PathLength;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge
implements SVGPathContext {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();
    Shape pathLengthShape = null;
    PathLength pathLength = null;

    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        String string = element.getAttributeNS(null, "d");
        if (string.length() != 0) {
            AWTPathProducer aWTPathProducer = new AWTPathProducer();
            aWTPathProducer.setWindingRule(CSSUtilities.convertFillRule(element));
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler(aWTPathProducer);
                pathParser.parse(string);
            }
            catch (ParseException parseException) {
                BridgeException bridgeException = new BridgeException(element, "attribute.malformed", new Object[]{"d"});
                bridgeException.setGraphicsNode(shapeNode);
                throw bridgeException;
            }
            finally {
                shapeNode.setShape(aWTPathProducer.getShape());
            }
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("d")) {
            if (mutationEvent.getNewValue().length() == 0) {
                ((ShapeNode)this.node).setShape(DEFAULT_SHAPE);
            } else {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            }
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    PathLength getPathLengthObj() {
        Shape shape = ((ShapeNode)this.node).getShape();
        if (this.pathLengthShape != shape) {
            this.pathLength = new PathLength(shape);
            this.pathLengthShape = shape;
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.lengthOfPath();
    }

    public Point2D getPointAtLength(float f) {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.pointAtLength(f);
    }
}

