/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import junit.framework.Assert;
import junitx.framework.AssertionFailedError;
import junitx.framework.ListAssert;
import junitx.util.NamingUtil;

public class NamingAssert {
    private NamingAssert() {
    }

    public static void assertEquals(Attributes expected, Attributes actual) {
        NamingAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Attributes expected, Attributes actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "[expected] expected not <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "[actual] expected not <null>"), (Object)actual);
        try {
            NamingEnumeration<String> ids = expected.getIDs();
            while (ids.hasMore()) {
                String key = ids.next().toString();
                NamingAssert.assertEquals(message, expected.get(key), actual.get(key));
            }
        }
        catch (NamingException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertEquals(Attribute expected, Attribute actual) {
        NamingAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Attribute expected, Attribute actual) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.assertNotNull((String)(formatted + "[expected] expected not <null>"), (Object)expected);
        Assert.assertNotNull((String)(formatted + "[actual] expected not <null>"), (Object)actual);
        try {
            NamingAssert.assertEquals(message, expected.getAll(), actual.getAll());
        }
        catch (NamingException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertEquals(NamingEnumeration expected, NamingEnumeration actual) {
        NamingAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, NamingEnumeration expected, NamingEnumeration actual) {
        try {
            ListAssert.assertEquals(message, NamingUtil.toList(expected), NamingUtil.toList(actual));
        }
        catch (NamingException e) {
            throw new AssertionFailedError(e);
        }
    }
}

