/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Keep;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.KeepProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class GenericKeep
extends KeepProperty.Maker {
    private static final Property.Maker s_WithinPageMaker = new SP_WithinPageMaker("generic-keep.within-page");
    private static final Property.Maker s_WithinLineMaker = new SP_WithinLineMaker("generic-keep.within-line");
    private static final Property.Maker s_WithinColumnMaker = new SP_WithinColumnMaker("generic-keep.within-column");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("within-page");
    private Property m_defaultProp = null;

    protected GenericKeep(String name) {
        super(name);
    }

    public Property checkEnumValues(String value) {
        return this.m_shorthandMaker.checkEnumValues(value);
    }

    public Property convertProperty(Property p, PropertyList pList, FObj fo) throws FOPException {
        if (p instanceof KeepProperty) {
            return p;
        }
        if (!(p instanceof EnumProperty)) {
            p = this.m_shorthandMaker.convertProperty(p, pList, fo);
        }
        if (p != null) {
            Property prop = this.makeCompound(pList, fo);
            Keep pval = prop.getKeep();
            pval.setComponent("within-page", p, false);
            pval.setComponent("within-line", p, false);
            pval.setComponent("within-column", p, false);
            return prop;
        }
        return null;
    }

    protected String getDefaultForWithinColumn() {
        return "auto";
    }

    protected String getDefaultForWithinLine() {
        return "auto";
    }

    protected String getDefaultForWithinPage() {
        return "auto";
    }

    protected Property.Maker getSubpropMaker(String subprop) {
        if (subprop.equals("within-page")) {
            return s_WithinPageMaker;
        }
        if (subprop.equals("within-line")) {
            return s_WithinLineMaker;
        }
        if (subprop.equals("within-column")) {
            return s_WithinColumnMaker;
        }
        return super.getSubpropMaker(subprop);
    }

    public Property getSubpropValue(Property baseProp, String subpropName) {
        Keep val = baseProp.getKeep();
        return val.getComponent(subpropName);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList pList, FObj fo) throws FOPException {
        Keep p = new Keep();
        Property subProp = this.getSubpropMaker("within-page").make(pList, this.getDefaultForWithinPage(), fo);
        p.setComponent("within-page", subProp, true);
        subProp = this.getSubpropMaker("within-line").make(pList, this.getDefaultForWithinLine(), fo);
        p.setComponent("within-line", subProp, true);
        subProp = this.getSubpropMaker("within-column").make(pList, this.getDefaultForWithinColumn(), fo);
        p.setComponent("within-column", subProp, true);
        return new KeepProperty(p);
    }

    public static Property.Maker maker(String propName) {
        return new GenericKeep(propName);
    }

    protected Property setSubprop(Property baseProp, String subpropName, Property subProp) {
        Keep val = baseProp.getKeep();
        val.setComponent(subpropName, subProp, false);
        return baseProp;
    }

    public static interface Enums {

        public static interface WithinPage {
            public static final int AUTO = 8;
            public static final int ALWAYS = 6;
        }

        public static interface WithinLine {
            public static final int AUTO = 8;
            public static final int ALWAYS = 6;
        }

        public static interface WithinColumn {
            public static final int AUTO = 8;
            public static final int ALWAYS = 6;
        }
    }

    private static class SP_WithinPageMaker
    extends NumberProperty.Maker
    implements Enums.WithinPage {
        protected static final EnumProperty s_propAUTO = new EnumProperty(8);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(6);

        SP_WithinPageMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("auto")) {
                return s_propAUTO;
            }
            if (value.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(value);
        }
    }

    private static class SP_WithinLineMaker
    extends NumberProperty.Maker
    implements Enums.WithinLine {
        protected static final EnumProperty s_propAUTO = new EnumProperty(8);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(6);

        SP_WithinLineMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("auto")) {
                return s_propAUTO;
            }
            if (value.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(value);
        }
    }

    private static class SP_WithinColumnMaker
    extends NumberProperty.Maker
    implements Enums.WithinColumn {
        protected static final EnumProperty s_propAUTO = new EnumProperty(8);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(6);

        SP_WithinColumnMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("auto")) {
                return s_propAUTO;
            }
            if (value.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(value);
        }
    }
}

