/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class Leader
extends FObjMixed {
    public Leader(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    public int addLeader(BlockArea ba, FontState fontState, float red, float green, float blue, int leaderPattern, int leaderLengthMinimum, int leaderLengthOptimum, int leaderLengthMaximum, int ruleThickness, int ruleStyle, int leaderPatternWidth, int leaderAlignment) {
        LineArea la = ba.getCurrentLineArea();
        if (la == null) {
            return -1;
        }
        la.changeFont(fontState);
        la.changeColor(red, green, blue);
        if (leaderLengthOptimum <= la.getRemainingWidth()) {
            la.addLeader(leaderPattern, leaderLengthMinimum, leaderLengthOptimum, leaderLengthMaximum, ruleStyle, ruleThickness, leaderPatternWidth, leaderAlignment);
        } else {
            la = ba.createNextLineArea();
            if (la == null) {
                return -1;
            }
            la.changeFont(fontState);
            la.changeColor(red, green, blue);
            if (leaderLengthMinimum <= la.getContentWidth()) {
                la.addLeader(leaderPattern, leaderLengthMinimum, leaderLengthOptimum, leaderLengthMaximum, ruleStyle, ruleThickness, leaderPatternWidth, leaderAlignment);
            } else {
                this.log.error("Leader doesn't fit into line, it will be clipped to fit.");
                la.addLeader(leaderPattern, la.getRemainingWidth(), la.getRemainingWidth(), la.getRemainingWidth(), ruleStyle, ruleThickness, leaderPatternWidth, leaderAlignment);
            }
        }
        return 1;
    }

    public String getName() {
        return "fo:leader";
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("in this version of Fop fo:leader must be a direct child of fo:block ");
            return 1;
        }
        BlockArea blockArea = (BlockArea)area;
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        ColorType c = this.properties.get("color").getColorType();
        float red = c.red();
        float green = c.green();
        float blue = c.blue();
        int leaderPattern = this.properties.get("leader-pattern").getEnum();
        Length length = this.properties.get("leader-length.minimum").getLength();
        int leaderLengthMinimum = length instanceof PercentLength ? (int)(((PercentLength)length).value() * (double)area.getAllocationWidth()) : length.mvalue();
        length = this.properties.get("leader-length.optimum").getLength();
        int leaderLengthOptimum = length instanceof PercentLength ? (int)(((PercentLength)length).value() * (double)area.getAllocationWidth()) : length.mvalue();
        length = this.properties.get("leader-length.maximum").getLength();
        int leaderLengthMaximum = length instanceof PercentLength ? (int)(((PercentLength)length).value() * (double)area.getAllocationWidth()) : length.mvalue();
        int ruleThickness = this.properties.get("rule-thickness").getLength().mvalue();
        int ruleStyle = this.properties.get("rule-style").getEnum();
        int leaderPatternWidth = this.properties.get("leader-pattern-width").getLength().mvalue();
        int leaderAlignment = this.properties.get("leader-alignment").getEnum();
        String id = this.properties.get("id").getString();
        try {
            blockArea.getIDReferences().initializeID(id, blockArea);
        }
        catch (FOPException e) {
            if (!e.isLocationSet()) {
                e.setLocation(this.systemId, this.line, this.column);
            }
            throw e;
        }
        int succeeded = this.addLeader(blockArea, this.propMgr.getFontState(area.getFontInfo()), red, green, blue, leaderPattern, leaderLengthMinimum, leaderLengthOptimum, leaderLengthMaximum, ruleThickness, ruleStyle, leaderPatternWidth, leaderAlignment);
        if (succeeded == 1) {
            return 1;
        }
        return 3;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Leader(parent, propertyList, systemId, line, column);
        }
    }
}

