/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer
extends FileContainer
implements PrivilegedExceptionAction {
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    private static final int BACKUP_CONTAINER_ACTION = 6;
    private static final int GET_RANDOM_ACCESS_FILE_ACTION = 7;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;
    private String actionBackupLocation;
    private BaseContainerHandle actionContainerHandle;
    private boolean inBackup = false;
    private boolean inRemove = false;

    RAFContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    public Cacheable setIdentity(Object object) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            TempRAFContainer tempRAFContainer = new TempRAFContainer(this.dataFactory);
            return tempRAFContainer.setIdent(containerKey);
        }
        return this.setIdent(containerKey);
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            TempRAFContainer tempRAFContainer = new TempRAFContainer(this.dataFactory);
            return tempRAFContainer.createIdent(containerKey, object2);
        }
        return this.createIdent(containerKey, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
        RAFContainer rAFContainer;
        try {
            RAFContainer rAFContainer2 = this;
            synchronized (rAFContainer2) {
                this.inRemove = true;
                while (this.inBackup) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
            }
            this.pageCache.discard(this.identity);
            this.stubbify(logInstant);
            Object var7_6 = null;
            rAFContainer = this;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            RAFContainer rAFContainer3 = this;
            synchronized (rAFContainer3) {
                this.inRemove = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (rAFContainer) {
            this.inRemove = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeContainer() {
        if (this.fileData != null) {
            try {
                this.fileData.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fileData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(l2);
            this.fileData.readFully(byArray, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                return;
            }
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted() && l != 0L) {
                byArray2 = this.getEncryptionBuffer();
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            try {
                this.fileData.seek(l2);
                if (this.fileData.getFilePointer() != l2) {
                    this.padFile(this.fileData, l2);
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            catch (IOException iOException) {
                if (!this.padFile(this.fileData, l2)) {
                    throw iOException;
                }
                this.fileData.seek(l2);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    this.fileData.sync(false);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                this.needsSync = true;
            }
            return;
        }
    }

    protected byte[] updatePageArray(long l, byte[] byArray, byte[] byArray2, boolean bl) throws StandardException, IOException {
        if (l == 0L) {
            this.writeHeader(byArray);
            return byArray;
        }
        if (this.dataFactory.databaseEncrypted() || bl) {
            return this.encryptPage(byArray, this.pageSize, byArray2, bl);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean padFile(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        long l2 = storageRandomAccessFile.length();
        if (l2 >= l) {
            return false;
        }
        byte[] byArray = new byte[this.pageSize];
        storageRandomAccessFile.seek(l2);
        while (l2 < l) {
            this.dataFactory.writeInProgress();
            try {
                long l3 = l - l2;
                if (l3 > (long)this.pageSize) {
                    l3 = this.pageSize;
                }
                storageRandomAccessFile.write(byArray, 0, (int)l3);
            }
            finally {
                this.dataFactory.writeFinished();
            }
            l2 += (long)this.pageSize;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean bl) throws StandardException {
        boolean bl2 = false;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                this.clearDirty();
                return;
            }
            while (this.preDirty) {
                bl2 = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw StandardException.interrupt(interruptedException);
                }
            }
            if (bl2 && this.getCommittedDropState()) {
                this.clearDirty();
                return;
            }
            if (!bl && this.isDirty()) {
                try {
                    this.writeRAFHeader(this.fileData, false, true);
                    this.clearDirty();
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this));
                }
            }
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int preAllocate(long l, int n) {
        int n2 = this.doPreAllocatePages(l, n);
        if (n2 > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                boolean bl = false;
                try {
                    this.dataFactory.writeInProgress();
                    bl = true;
                    if (!this.dataFactory.dataNotSyncedAtAllocation) {
                        this.fileData.sync(false);
                    }
                }
                catch (IOException iOException) {
                    n2 = 0;
                }
                catch (StandardException standardException) {
                    n2 = 0;
                }
                finally {
                    if (bl) {
                        this.dataFactory.writeFinished();
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncatePages(long l) throws StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            boolean bl = false;
            try {
                this.dataFactory.writeInProgress();
                bl = true;
                this.fileData.setLength((l + 1L) * (long)this.pageSize);
            }
            catch (IOException iOException) {
            }
            catch (StandardException standardException) {
            }
            finally {
                if (bl) {
                    this.dataFactory.writeFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRAFHeader(StorageRandomAccessFile storageRandomAccessFile, boolean bl, boolean bl2) throws IOException, StandardException {
        byte[] byArray;
        if (bl) {
            byArray = this.getEmbryonicPage(null);
        } else {
            storageRandomAccessFile.seek(0L);
            byArray = this.getEmbryonicPage(storageRandomAccessFile);
        }
        storageRandomAccessFile.seek(0L);
        this.writeHeader(storageRandomAccessFile, bl, byArray);
        if (bl) {
            this.padFile(storageRandomAccessFile, this.pageSize);
        }
        if (bl2) {
            this.dataFactory.writeInProgress();
            try {
                if (!this.dataFactory.dataNotSyncedAtCheckpoint) {
                    storageRandomAccessFile.sync(false);
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
        }
        byArray = null;
    }

    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    synchronized StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = containerKey;
        this.actionStub = bl;
        this.actionErrorOK = bl2;
        this.actionTryAlternatePath = bl3;
        try {
            StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
            return storageFile;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile privGetFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = this.dataFactory.getContainerPath(containerKey, bl);
        if (!storageFile2.exists() && bl3) {
            storageFile2 = this.dataFactory.getAlternateContainerPath(containerKey, bl);
        }
        if (!storageFile2.exists() && !(storageFile = storageFile2.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!storageFile.exists() && !storageFile.mkdirs()) {
                    if (bl2) {
                        return null;
                    }
                    throw StandardException.newException("XSDF3.S", storageFile);
                }
            }
        }
        return storageFile2;
    }

    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 2;
        this.actionIdentity = containerKey;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    synchronized boolean removeFile(StorageFile storageFile) throws SecurityException, StandardException {
        this.actionCode = 3;
        this.actionFile = storageFile;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean privRemoveFile(StorageFile storageFile) throws StandardException {
        this.closeContainer();
        this.dataFactory.writeInProgress();
        try {
            if (storageFile.exists()) {
                boolean bl = storageFile.delete();
                return bl;
            }
        }
        finally {
            this.dataFactory.writeFinished();
        }
        return true;
    }

    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = containerKey;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private synchronized void stubbify(LogInstant logInstant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = logInstant;
        this.actionCode = 5;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionIdentity = null;
            this.actionInstant = null;
        }
    }

    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        this.actionContainerHandle = baseContainerHandle;
        this.actionBackupLocation = string;
        this.actionCode = 6;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionContainerHandle = null;
            this.actionBackupLocation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void privBackupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        Object object32;
        Object var18_16;
        boolean bl = false;
        File file = null;
        RandomAccessFile randomAccessFile = null;
        boolean bl2 = false;
        BasePage basePage = null;
        while (!bl) {
            Object object2 = this;
            // MONITORENTER : object2
            while (this.inRemove) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw StandardException.interrupt(interruptedException);
                }
            }
            if (this.getCommittedDropState()) {
                bl2 = true;
            }
            this.inBackup = true;
            // MONITOREXIT : object2
            if (bl2) {
                object2 = this.privGetFileName((ContainerKey)this.getIdentity(), true, false, true);
                file = new File(string, object2.getName());
                if (!FileUtil.copyFile(this.dataFactory.getStorageFactory(), (StorageFile)object2, file)) {
                    throw StandardException.newException("XSRS5.S", object2, (Object)file);
                }
            } else {
                long l = this.getLastPageNumber(baseContainerHandle);
                if (l == -1L) {
                    var18_16 = null;
                    object32 = this;
                    // MONITORENTER : object32
                    this.inBackup = false;
                    this.notifyAll();
                    // MONITOREXIT : object32
                    if (basePage != null) {
                        basePage.unlatch();
                        basePage = null;
                    }
                    if (bl) return;
                    if (file == null) return;
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                            randomAccessFile = null;
                        }
                        catch (IOException object32) {
                            throw StandardException.newException("XSDFH.S", (Throwable)object32, (Object)file);
                        }
                    }
                    if (!file.exists()) return;
                    if (file.delete()) return;
                    throw StandardException.newException("XBM0R.D", file);
                }
                StorageFile storageFile = this.privGetFileName((ContainerKey)this.getIdentity(), false, false, true);
                file = new File(string, storageFile.getName());
                randomAccessFile = new RandomAccessFile(file, "rw");
                byte[] byArray = null;
                if (this.dataFactory.databaseEncrypted()) {
                    byArray = new byte[this.pageSize];
                }
                for (long i = 0L; i <= l; ++i) {
                    basePage = this.getLatchedPage(baseContainerHandle, i);
                    byte[] byArray2 = this.updatePageArray(i, basePage.getPageArray(), byArray, false);
                    randomAccessFile.write(byArray2, 0, this.pageSize);
                    basePage.unlatch();
                    basePage = null;
                    RAFContainer rAFContainer = this;
                    // MONITORENTER : rAFContainer
                    if (this.inRemove) {
                        // MONITOREXIT : rAFContainer
                        break;
                    }
                    // MONITOREXIT : rAFContainer
                }
            }
            if (!bl2) {
                randomAccessFile.getFD().sync();
                randomAccessFile.close();
                randomAccessFile = null;
            }
            bl = true;
            var18_16 = null;
            object32 = this;
            // MONITORENTER : object32
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : object32
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (bl || file == null) continue;
            if (randomAccessFile != null) {
                try {}
                catch (IOException object32) {
                    throw StandardException.newException("XSDFH.S", (Throwable)object32, (Object)file);
                }
                randomAccessFile.close();
                randomAccessFile = null;
            }
            if (file.exists() && !file.delete()) throw StandardException.newException("XBM0R.D", file);
        }
        return;
        {
            catch (IOException iOException) {
                throw StandardException.newException("XSDFH.S", iOException, file);
            }
        }
        catch (Throwable throwable) {
            var18_16 = null;
            object32 = this;
            // MONITORENTER : object32
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : object32
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (bl) throw throwable;
            if (file == null) throw throwable;
            if (randomAccessFile != null) {
                try {}
                catch (IOException object32) {
                    throw StandardException.newException("XSDFH.S", (Throwable)object32, (Object)file);
                }
                randomAccessFile.close();
                randomAccessFile = null;
            }
            if (!file.exists()) throw throwable;
            if (file.delete()) throw throwable;
            throw StandardException.newException("XBM0R.D", file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void encryptContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        BasePage basePage = null;
        StorageFile storageFile = this.dataFactory.getStorageFactory().newStorageFile(string);
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            try {
                long l = this.getLastPageNumber(baseContainerHandle);
                storageRandomAccessFile = this.privGetRandomAccessFile(storageFile);
                byte[] byArray = null;
                byArray = new byte[this.pageSize];
                for (long i = 0L; i <= l; ++i) {
                    basePage = this.getLatchedPage(baseContainerHandle, i);
                    byte[] byArray2 = this.updatePageArray(i, basePage.getPageArray(), byArray, true);
                    storageRandomAccessFile.write(byArray2, 0, this.pageSize);
                    basePage.unlatch();
                    basePage = null;
                }
                storageRandomAccessFile.sync(true);
                storageRandomAccessFile.close();
                storageRandomAccessFile = null;
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSDG3.D", iOException, (Object)storageFile);
            }
            Object var13_11 = null;
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (storageRandomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (storageRandomAccessFile == null) throw throwable;
            try {
                storageRandomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                storageRandomAccessFile = null;
                throw StandardException.newException("XSDG3.D", iOException, (Object)storageFile);
            }
        }
        try {}
        catch (IOException iOException) {
            storageRandomAccessFile = null;
            throw StandardException.newException("XSDG3.D", iOException, (Object)storageFile);
        }
        storageRandomAccessFile.close();
    }

    synchronized StorageRandomAccessFile privGetRandomAccessFile(StorageFile storageFile) throws SecurityException, StandardException {
        this.actionCode = 7;
        this.actionFile = storageFile;
        try {
            StorageRandomAccessFile storageRandomAccessFile = (StorageRandomAccessFile)AccessController.doPrivileged(this);
            return storageRandomAccessFile;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws StandardException, IOException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, false);
                try {
                    if (storageFile.exists()) {
                        throw StandardException.newException("XSDF0.S", storageFile);
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF1.S", securityException, (Object)storageFile);
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = storageFile.getRandomAccessFile("rw");
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.writeRAFHeader(this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF1.S", securityException, (Object)storageFile);
                }
                catch (IOException iOException) {
                    boolean bl;
                    try {
                        bl = this.privRemoveFile(storageFile);
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, (Object)securityException.toString());
                    }
                    if (!bl) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, (Object)iOException.toString());
                    }
                    throw StandardException.newException("XSDF1.S", iOException, (Object)storageFile);
                }
                this.canUpdate = true;
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean bl = false;
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                if (storageFile == null) {
                    return null;
                }
                try {
                    if (!storageFile.exists()) {
                        storageFile = this.privGetFileName(this.actionIdentity, true, true, true);
                        if (!storageFile.exists()) {
                            return null;
                        }
                        bl = true;
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDA4.S", securityException);
                }
                this.canUpdate = false;
                try {
                    if (!this.dataFactory.isReadOnly() && storageFile.canWrite()) {
                        this.canUpdate = true;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.fileData.seek(0L);
                    this.readHeader(this.fileData);
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this));
                    }
                    StorageFile storageFile2 = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (storageFile2.exists()) {
                        try {
                            boolean bl2 = this.privRemoveFile(storageFile);
                            this.fileData = storageFile2.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.fileData);
                        }
                        catch (IOException iOException2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException2, (Object)this));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this));
                }
                return this;
            }
            case 5: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile storageFile3 = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (!storageFile3.exists()) {
                        storageRandomAccessFile = storageFile3.getRandomAccessFile("rw");
                        this.writeRAFHeader(storageRandomAccessFile, true, true);
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(storageFile);
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)securityException.toString());
                }
                catch (IOException iOException) {
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageFile3.delete();
                            storageRandomAccessFile = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException iOException3) {
                        throw StandardException.newException("XSDF4.S", iOException3, (Object)storageFile, (Object)iOException.toString());
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)storageFile3);
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(storageFile3, this.actionInstant, this.getIdentity());
                return null;
            }
            case 6: {
                this.privBackupContainer(this.actionContainerHandle, this.actionBackupLocation);
                return null;
            }
            case 7: {
                return this.actionFile.getRandomAccessFile("rw");
            }
        }
        return null;
    }
}

