/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.tools.CompressTool;

public class FileStoreInputStream
extends InputStream {
    private FileStore store;
    private DataPage page;
    private int remainingInBuffer;
    private CompressTool compress;
    private boolean endOfFile;
    private boolean alwaysClose;

    public FileStoreInputStream(FileStore store, DataHandler handler, boolean compression, boolean alwaysClose) throws SQLException {
        this.store = store;
        this.alwaysClose = alwaysClose;
        if (compression) {
            this.compress = CompressTool.getInstance();
        }
        this.page = DataPage.create(handler, 16);
        try {
            if (store.length() <= 48L) {
                this.close();
            } else {
                this.fillBuffer();
            }
        }
        catch (IOException e) {
            throw Message.convertIOException(e, store.name);
        }
    }

    public int available() {
        return this.remainingInBuffer <= 0 ? 0 : this.remainingInBuffer;
    }

    public int read(byte[] buff) throws IOException {
        return this.read(buff, 0, buff.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r;
        if (len == 0) {
            return 0;
        }
        int read = 0;
        while (len > 0 && (r = this.readBlock(b, off, len)) >= 0) {
            read += r;
            off += r;
            len -= r;
        }
        return read == 0 ? -1 : read;
    }

    public int readBlock(byte[] buff, int off, int len) throws IOException {
        this.fillBuffer();
        if (this.endOfFile) {
            return -1;
        }
        int l = Math.min(this.remainingInBuffer, len);
        this.page.read(buff, off, l);
        this.remainingInBuffer -= l;
        return l;
    }

    private void fillBuffer() throws IOException {
        if (this.remainingInBuffer > 0 || this.endOfFile) {
            return;
        }
        this.page.reset();
        try {
            this.store.openFile();
            if (this.store.length() == this.store.getFilePointer()) {
                this.close();
                return;
            }
            this.store.readFully(this.page.getBytes(), 0, 16);
        }
        catch (SQLException e) {
            throw Message.convertToIOException(e);
        }
        this.page.reset();
        this.remainingInBuffer = this.page.readInt();
        if (this.remainingInBuffer < 0) {
            this.close();
            return;
        }
        this.page.checkCapacity(this.remainingInBuffer);
        if (this.compress != null) {
            this.page.checkCapacity(this.page.getIntLen());
            this.page.readInt();
        }
        this.page.setPos(this.page.length() + this.remainingInBuffer);
        this.page.fillAligned();
        int len = this.page.length() - 16;
        this.page.reset();
        this.page.readInt();
        try {
            this.store.readFully(this.page.getBytes(), 16, len);
            this.page.reset();
            this.page.readInt();
            if (this.compress != null) {
                int uncompressed = this.page.readInt();
                byte[] buff = new byte[this.remainingInBuffer];
                this.page.read(buff, 0, this.remainingInBuffer);
                this.page.reset();
                this.page.checkCapacity(uncompressed);
                this.compress.expand(buff, this.page.getBytes(), 0);
                this.remainingInBuffer = uncompressed;
            }
        }
        catch (SQLException e) {
            throw Message.convertToIOException(e);
        }
        if (this.alwaysClose) {
            this.store.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            try {
                this.store.close();
                this.endOfFile = true;
            }
            finally {
                this.store = null;
            }
        }
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.endOfFile) {
            return -1;
        }
        int i = this.page.readByte() & 0xFF;
        --this.remainingInBuffer;
        return i;
    }
}

