/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.ByteUtils;

public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private byte[] userPasswordHash;
    private byte[] salt;
    private byte[] hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        SHA256 sha = new SHA256();
        this.userPasswordHash = sha.getKeyPasswordHash(this.userName, password.toCharArray());
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (db.findUser(this.userName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90033, this.userName);
        }
        int id = this.getObjectId(false, true);
        User user = new User(db, id, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            user.setSaltAndHash(this.salt, this.hash);
        } else {
            user.setUserPasswordHash(this.userPasswordHash);
        }
        db.addDatabaseObject(this.session, user);
        return 0;
    }

    public void setSalt(String s) throws SQLException {
        this.salt = ByteUtils.convertStringToBytes(s);
    }

    public void setHash(String s) throws SQLException {
        this.hash = ByteUtils.convertStringToBytes(s);
    }

    public void setAdmin(boolean b) {
        this.admin = b;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

