/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.TrustManager;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNSSLTrustManager;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPasswordCipher;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNAuthenticationManager
implements ISVNAuthenticationManager {
    private boolean myIsStoreAuth;
    private ISVNAuthenticationProvider[] myProviders;
    private File myConfigDirectory;
    private SVNAuthentication myPreviousAuthentication;
    private SVNErrorMessage myPreviousErrorMessage;
    private SVNCompositeConfigFile myServersFile;
    private ISVNAuthenticationStorage myRuntimeAuthStorage;
    private int myLastProviderIndex;
    private SVNCompositeConfigFile myConfigFile;
    private boolean myIsAuthenticationForced;
    private SVNAuthentication myLastLoadedAuth;
    private ISVNAuthStoreHandler myAuthStoreHandler;
    private Map myServersOptions;
    private Map myConfigOptions;

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password) {
        this(configDirectory, storeAuth, userName, password, null, null);
    }

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password, File privateKey, String passphrase) {
        this.myIsStoreAuth = storeAuth;
        this.myConfigDirectory = configDirectory;
        if (this.myConfigDirectory == null) {
            this.myConfigDirectory = SVNWCUtil.getDefaultConfigurationDirectory();
        }
        this.myProviders = new ISVNAuthenticationProvider[4];
        this.myProviders[0] = this.createDefaultAuthenticationProvider(userName, password, privateKey, passphrase, this.myIsStoreAuth);
        this.myProviders[1] = this.createRuntimeAuthenticationProvider();
        this.myProviders[2] = this.createCacheAuthenticationProvider(new File(this.myConfigDirectory, "auth"), userName);
    }

    public void setAuthStoreHandler(ISVNAuthStoreHandler authStoreHandler) {
        this.myAuthStoreHandler = authStoreHandler;
    }

    public void setInMemoryServersOptions(Map serversOptions) {
        this.myServersOptions = serversOptions;
    }

    public void setInMemoryConfigOptions(Map configOptions) {
        this.myConfigOptions = configOptions;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        this.myProviders[3] = provider;
    }

    public Collection getAuthTypes(SVNURL url) {
        ArrayList<String> schemes = new ArrayList<String>();
        String host = url.getHost();
        Map hostProperties = this.getHostProperties(host);
        String authTypes = (String)hostProperties.get("http-auth-types");
        if (authTypes == null || "".equals(authTypes.trim())) {
            return schemes;
        }
        StringTokenizer tokens = new StringTokenizer(authTypes, ";");
        while (tokens.hasMoreTokens()) {
            String scheme = tokens.nextToken();
            if (schemes.contains(scheme)) continue;
            schemes.add(scheme);
        }
        return schemes;
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        String proxyHost = (String)properties.get("http-proxy-host");
        if (proxyHost == null || "".equals(proxyHost.trim())) {
            proxyHost = System.getProperty("http.proxyHost");
            properties.put("http-proxy-port", System.getProperty("http.proxyPort"));
        }
        if (proxyHost == null || "".equals(proxyHost.trim())) {
            return null;
        }
        String proxyExceptions = (String)properties.get("http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches(exception, host)) continue;
                return null;
            }
        }
        String proxyPort = (String)properties.get("http-proxy-port");
        String proxyUser = (String)properties.get("http-proxy-username");
        String proxyPassword = (String)properties.get("http-proxy-password");
        return new SimpleProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        boolean trustAll = !"no".equalsIgnoreCase((String)properties.get("ssl-trust-default-ca"));
        String sslAuthorityFiles = (String)properties.get("ssl-authority-files");
        ArrayList<File> trustStorages = new ArrayList<File>();
        if (sslAuthorityFiles != null) {
            StringTokenizer files = new StringTokenizer(sslAuthorityFiles, ";");
            while (files.hasMoreTokens()) {
                String fileName = files.nextToken();
                fileName = fileName == null ? null : fileName.trim();
                if (fileName == null || "".equals(fileName)) continue;
                trustStorages.add(new File(fileName));
            }
        }
        File[] serverCertFiles = trustStorages.toArray(new File[trustStorages.size()]);
        File authDir = new File(this.myConfigDirectory, "auth/svn.ssl.server");
        return new DefaultSVNSSLTrustManager(authDir, url, serverCertFiles, trustAll, this);
    }

    private Map getHostProperties(String host) {
        Map globalProps = this.getServersFile().getProperties("global");
        String groupName = DefaultSVNAuthenticationManager.getGroupName(this.getServersFile().getProperties("groups"), host);
        if (groupName != null) {
            Map hostProps = this.getServersFile().getProperties(groupName);
            globalProps.putAll(hostProps);
        }
        return globalProps;
    }

    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        this.myPreviousAuthentication = null;
        this.myPreviousErrorMessage = null;
        this.myLastProviderIndex = 0;
        this.myLastLoadedAuth = null;
        for (int i = 0; i < this.myProviders.length; ++i) {
            if (this.myProviders[i] == null) continue;
            SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, null, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (auth != null) {
                if (i == 2) {
                    this.myLastLoadedAuth = auth;
                }
                this.myPreviousAuthentication = auth;
                this.myLastProviderIndex = i;
                if (auth.isPartial()) continue;
                return auth;
            }
            if (i != 3) continue;
            SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
        }
        if ("svn.username".equals(kind)) {
            return new SVNUserNameAuthentication("", this.isAuthStorageEnabled(url), url, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        int index;
        for (int i = index = Math.min(this.myLastProviderIndex + 1, 3); i < this.myProviders.length; ++i) {
            if (this.myProviders[i] == null || (i == 1 || i == 2) && this.hasExplicitCredentials(kind)) continue;
            SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, this.myPreviousErrorMessage, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (auth != null) {
                if (i == 2) {
                    this.myLastLoadedAuth = auth;
                }
                this.myPreviousAuthentication = auth;
                this.myLastProviderIndex = i;
                if (auth.isPartial()) continue;
                return auth;
            }
            if (i != 3) continue;
            SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        if (!accepted) {
            this.myPreviousErrorMessage = errorMessage;
            this.myPreviousAuthentication = authentication;
            this.myLastLoadedAuth = null;
            return;
        }
        if (this.myIsStoreAuth && authentication.isStorageAllowed() && this.myProviders[2] instanceof IPersistentAuthenticationProvider && (this.myLastLoadedAuth == null || this.myLastLoadedAuth != authentication)) {
            ((IPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveAuthentication(authentication, kind, realm);
        }
        this.myLastLoadedAuth = null;
        if (!this.hasExplicitCredentials(kind)) {
            ((CacheAuthenticationProvider)this.myProviders[1]).saveAuthentication(authentication, realm);
        }
    }

    public void acknowledgeTrustManager(TrustManager manager) {
    }

    private boolean hasExplicitCredentials(String kind) {
        if (("svn.simple".equals(kind) || "svn.username".equals(kind) || "svn.ssh".equals(kind)) && this.myProviders[0] instanceof DumbAuthenticationProvider) {
            DumbAuthenticationProvider authProvider = (DumbAuthenticationProvider)this.myProviders[0];
            String userName = authProvider.myUserName;
            String password = authProvider.myPassword;
            if ("svn.username".equals(kind)) {
                return userName != null && !"".equals(userName);
            }
            return password != null && !"".equals(password) && userName != null && !"".equals(userName);
        }
        return false;
    }

    protected SVNCompositeConfigFile getServersFile() {
        if (this.myServersFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "servers"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"));
            this.myServersFile = new SVNCompositeConfigFile(systemConfig, userConfig);
            this.myServersFile.setGroupsToOptions(this.myServersOptions);
        }
        return this.myServersFile;
    }

    protected SVNCompositeConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "config"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
            this.myConfigFile = new SVNCompositeConfigFile(systemConfig, userConfig);
            this.myConfigFile.setGroupsToOptions(this.myConfigOptions);
        }
        return this.myConfigFile;
    }

    public void setRuntimeStorage(ISVNAuthenticationStorage storage) {
        this.myRuntimeAuthStorage = storage;
    }

    protected ISVNAuthenticationStorage getRuntimeAuthStorage() {
        if (this.myRuntimeAuthStorage == null) {
            this.myRuntimeAuthStorage = new ISVNAuthenticationStorage(){
                private Map myData = new SVNHashMap();

                public void putData(String kind, String realm, Object data) {
                    this.myData.put(kind + "$" + realm, data);
                }

                public Object getData(String kind, String realm) {
                    return this.myData.get(kind + "$" + realm);
                }
            };
        }
        return this.myRuntimeAuthStorage;
    }

    protected boolean isAuthStorageEnabled(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storeAuthCreds = (String)properties.get("store-auth-creds");
        if (storeAuthCreds == null) {
            return this.myIsStoreAuth;
        }
        return "yes".equalsIgnoreCase(storeAuthCreds) || "on".equalsIgnoreCase(storeAuthCreds) || "true".equalsIgnoreCase(storeAuthCreds);
    }

    protected boolean isStorePasswords(SVNURL url) {
        String host;
        Map properties;
        String storePasswords;
        boolean store = true;
        String value = this.getConfigFile().getPropertyValue("auth", "store-passwords");
        if (value != null) {
            store = "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
        }
        if ((storePasswords = (String)(properties = this.getHostProperties(host = url != null ? url.getHost() : null)).get("store-passwords")) == null) {
            return store;
        }
        return "yes".equalsIgnoreCase(storePasswords) || "on".equalsIgnoreCase(storePasswords) || "true".equalsIgnoreCase(storePasswords);
    }

    protected boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
        SVNURL url = auth.getURL();
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storePlainTextPasswords = (String)properties.get("store-plaintext-passwords");
        if (storePlainTextPasswords == null) {
            if (this.myAuthStoreHandler != null) {
                return this.myAuthStoreHandler.canStorePlainTextPasswords(realm, auth);
            }
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPasswords) || "on".equalsIgnoreCase(storePlainTextPasswords) || "true".equalsIgnoreCase(storePlainTextPasswords);
    }

    protected boolean isStoreSSLClientCertificatePassphrases(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storeCertPassphrases = (String)properties.get("store-ssl-client-cert-pp");
        if (storeCertPassphrases == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(storeCertPassphrases) || "on".equalsIgnoreCase(storeCertPassphrases) || "true".equalsIgnoreCase(storeCertPassphrases);
    }

    protected boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
        SVNURL url = auth.getURL();
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storePlainTextPassphrases = (String)properties.get("store-ssl-client-cert-pp-plaintext");
        if (storePlainTextPassphrases == null) {
            if (this.myAuthStoreHandler != null) {
                return this.myAuthStoreHandler.canStorePlainTextPassphrases(realm, auth);
            }
            return false;
        }
        return "yes".equalsIgnoreCase(storePlainTextPassphrases) || "on".equalsIgnoreCase(storePlainTextPassphrases) || "true".equalsIgnoreCase(storePlainTextPassphrases);
    }

    protected String getUserName(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String userName = (String)properties.get("username");
        return userName;
    }

    protected ISVNAuthenticationProvider getAuthenticationProvider() {
        return this.myProviders[3];
    }

    protected int getDefaultSSHPortNumber() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            return -1;
        }
        String sshProgram = (String)tunnels.get("ssh");
        if (sshProgram == null) {
            return -1;
        }
        String port = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, sshProgram.toLowerCase().trim().startsWith("plink") ? "-p" : "-P");
        String string = port = port == null ? System.getProperty("svnkit.ssh2.port", System.getProperty("javasvn.ssh2.port")) : port;
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1;
    }

    protected SVNSSHAuthentication getDefaultSSHAuthentication() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            tunnels = new SVNHashMap();
        }
        String sshProgram = (String)tunnels.get("ssh");
        String userName = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-l");
        String password = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-pw");
        String keyFile = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-i");
        String port = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, sshProgram != null && sshProgram.toLowerCase().trim().startsWith("plink") ? "-P" : "-p");
        String passphrase = null;
        userName = userName == null ? System.getProperty("svnkit.ssh2.username", System.getProperty("javasvn.ssh2.username")) : userName;
        keyFile = keyFile == null ? System.getProperty("svnkit.ssh2.key", System.getProperty("javasvn.ssh2.key")) : keyFile;
        passphrase = passphrase == null ? System.getProperty("svnkit.ssh2.passphrase", System.getProperty("javasvn.ssh2.passphrase")) : passphrase;
        password = password == null ? System.getProperty("svnkit.ssh2.password", System.getProperty("javasvn.ssh2.password")) : password;
        String string = port = port == null ? System.getProperty("svnkit.ssh2.port", System.getProperty("javasvn.ssh2.port")) : port;
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        int portNumber = -1;
        if (port != null) {
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (userName != null && password != null) {
            return new SVNSSHAuthentication(userName, password, portNumber, this.isAuthStorageEnabled(null), null, false);
        }
        if (userName != null && keyFile != null) {
            return new SVNSSHAuthentication(userName, new File(keyFile), passphrase, portNumber, this.isAuthStorageEnabled(null), null, false);
        }
        return null;
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean allowSave) {
        return new DumbAuthenticationProvider(userName, password, privateKey, passphrase, allowSave);
    }

    protected ISVNAuthenticationProvider createRuntimeAuthenticationProvider() {
        return new CacheAuthenticationProvider();
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir, String userName) {
        return new PersistentAuthenticationProvider(authDir, userName);
    }

    private static String getOptionValue(String commandLine, String optionName) {
        if (commandLine == null || optionName == null) {
            return null;
        }
        StringTokenizer options = new StringTokenizer(commandLine, " \r\n\t");
        while (options.hasMoreTokens()) {
            String option = options.nextToken().trim();
            if (optionName.equals(option) && options.hasMoreTokens()) {
                return options.nextToken();
            }
            if (!option.startsWith(optionName)) continue;
            return option.substring(optionName.length());
        }
        return null;
    }

    private static String getGroupName(Map groups, String host) {
        for (String name : groups.keySet()) {
            String pattern = (String)groups.get(name);
            StringTokenizer tokens = new StringTokenizer(pattern, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!DefaultSVNOptions.matches(token, host)) continue;
                return name;
            }
        }
        return null;
    }

    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean forced) {
        this.myIsAuthenticationForced = forced;
    }

    public int getReadTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            String host = repository.getLocation().getHost();
            Map properties = this.getHostProperties(host);
            String timeout = (String)properties.get("http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    public int getConnectTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 60000;
        }
        return 0;
    }

    private static final class SimpleProxyManager
    implements ISVNProxyManager {
        private String myProxyHost;
        private String myProxyPort;
        private String myProxyUser;
        private String myProxyPassword;

        public SimpleProxyManager(String host, String port, String user, String password) {
            this.myProxyHost = host;
            this.myProxyPort = port == null ? "3128" : port;
            this.myProxyUser = user;
            this.myProxyPassword = password;
        }

        public String getProxyHost() {
            return this.myProxyHost;
        }

        public int getProxyPort() {
            try {
                return Integer.parseInt(this.myProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                return 3128;
            }
        }

        public String getProxyUserName() {
            return this.myProxyUser;
        }

        public String getProxyPassword() {
            return this.myProxyPassword;
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    }

    private class PersistentAuthenticationProvider
    implements ISVNAuthenticationProvider,
    IPersistentAuthenticationProvider {
        private File myDirectory;
        private String myUserName;

        public PersistentAuthenticationProvider(File directory, String userName) {
            this.myDirectory = directory;
            this.myUserName = userName;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            block19: {
                String host;
                Map properties;
                String sslClientCert;
                if ("svn.ssl.client-passphrase".equals(kind) && (sslClientCert = (String)(properties = DefaultSVNAuthenticationManager.this.getHostProperties(host = url.getHost())).get("ssl-client-cert-file")) != null && !"".equals(sslClientCert)) {
                    String sslClientCertPassword = (String)properties.get("ssl-client-cert-password");
                    File clientCertFile = sslClientCert != null ? new File(sslClientCert) : null;
                    return new SVNSSLAuthentication(clientCertFile, sslClientCertPassword, authMayBeStored, url, false);
                }
                File dir = new File(this.myDirectory, kind);
                if (!dir.isDirectory()) {
                    return null;
                }
                String fileName = SVNFileUtil.computeChecksum(realm);
                File authFile = new File(dir, fileName);
                if (authFile.exists()) {
                    SVNWCProperties props = new SVNWCProperties(authFile, "");
                    try {
                        SVNProperties values = props.asMap();
                        String storedRealm = values.getStringValue("svn:realmstring");
                        String cipherType = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passtype"));
                        if (cipherType != null && !SVNPasswordCipher.hasCipher(cipherType)) {
                            return null;
                        }
                        SVNPasswordCipher cipher = SVNPasswordCipher.getInstance(cipherType);
                        if (storedRealm == null || !storedRealm.equals(realm)) {
                            return null;
                        }
                        String userName = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("username"));
                        if (!"svn.ssl.client-passphrase".equals(kind)) {
                            if (userName == null || "".equals(userName.trim())) {
                                return null;
                            }
                            if (this.myUserName != null && !this.myUserName.equals(userName)) {
                                return null;
                            }
                        }
                        String password = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("password"));
                        password = cipher.decrypt(password);
                        String path = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("key"));
                        String passphrase = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passphrase"));
                        passphrase = cipher.decrypt(passphrase);
                        String port = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("port"));
                        String string = port = port == null ? "" + DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber() : port;
                        if ("svn.simple".equals(kind)) {
                            if (password == null) {
                                return new SVNPasswordAuthentication(userName, password, authMayBeStored, null, true);
                            }
                            return new SVNPasswordAuthentication(userName, password, authMayBeStored, url, false);
                        }
                        if ("svn.ssh".equals(kind)) {
                            int portNumber;
                            try {
                                portNumber = Integer.parseInt(port);
                            }
                            catch (NumberFormatException nfe) {
                                portNumber = DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber();
                            }
                            if (path != null) {
                                return new SVNSSHAuthentication(userName, new File(path), passphrase, portNumber, authMayBeStored, url, false);
                            }
                            if (password != null) {
                                return new SVNSSHAuthentication(userName, password, portNumber, authMayBeStored, url, false);
                            }
                            break block19;
                        }
                        if ("svn.username".equals(kind)) {
                            return new SVNUserNameAuthentication(userName, authMayBeStored, url, false);
                        }
                        if ("svn.ssl.client-passphrase".equals(kind)) {
                            return new SVNSSLAuthentication(new File(path), passphrase, authMayBeStored, url, false);
                        }
                    }
                    catch (SVNException e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveAuthentication(SVNAuthentication auth, String kind, String realm) throws SVNException {
            File dir = new File(this.myDirectory, kind);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.isDirectory()) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", dir.getAbsolutePath());
                SVNErrorManager.error(error, SVNLogType.DEFAULT);
            }
            if (!"svn.ssl.client-passphrase".equals(kind) && ("".equals(auth.getUserName()) || auth.getUserName() == null)) {
                return;
            }
            SVNHashMap values = new SVNHashMap();
            values.put("svn:realmstring", realm);
            if ("svn.simple".equals(kind)) {
                this.savePasswordCredential(values, auth, realm);
            } else if ("svn.ssh".equals(kind)) {
                this.saveSSHCredential(values, auth, realm);
            } else if ("svn.ssl.client-passphrase".equals(kind)) {
                this.saveSSLCredential(values, auth, realm);
            } else if ("svn.username".equals(kind)) {
                this.saveUserNameCredential(values, auth);
            }
            String fileName = SVNFileUtil.computeChecksum(realm);
            File authFile = new File(dir, fileName);
            if (authFile.isFile()) {
                SVNWCProperties props = new SVNWCProperties(authFile, "");
                try {
                    if (((Object)values).equals(props.asMap())) {
                        return;
                    }
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
            File tmpFile = SVNFileUtil.createUniqueFile(dir, "auth", ".tmp", true);
            try {
                SVNWCProperties.setProperties(SVNProperties.wrap(values), authFile, tmpFile, "END");
            }
            finally {
                SVNFileUtil.deleteFile(tmpFile);
            }
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }

        private void saveUserNameCredential(Map values, SVNAuthentication auth) {
            values.put("username", auth.getUserName());
        }

        private void savePasswordCredential(Map values, SVNAuthentication auth, String realm) throws SVNException {
            values.put("username", auth.getUserName());
            boolean storePasswords = DefaultSVNAuthenticationManager.this.isStorePasswords(auth.getURL());
            boolean maySavePassword = false;
            SVNPasswordCipher cipher = null;
            if (storePasswords) {
                String cipherType = SVNPasswordCipher.getDefaultCipherType();
                cipher = SVNPasswordCipher.getInstance(cipherType);
                if (cipherType != null && (maySavePassword = !"simple".equals(cipherType) ? true : DefaultSVNAuthenticationManager.this.isStorePlainTextPasswords(realm, auth))) {
                    values.put("passtype", cipherType);
                }
            }
            if (maySavePassword) {
                SVNPasswordAuthentication passwordAuth = (SVNPasswordAuthentication)auth;
                values.put("password", cipher.encrypt(passwordAuth.getPassword()));
            }
        }

        private void saveSSHCredential(Map values, SVNAuthentication auth, String realm) throws SVNException {
            values.put("username", auth.getUserName());
            boolean storePasswords = DefaultSVNAuthenticationManager.this.isStorePasswords(auth.getURL());
            boolean maySavePassword = false;
            SVNPasswordCipher cipher = null;
            if (storePasswords) {
                String cipherType = SVNPasswordCipher.getDefaultCipherType();
                cipher = SVNPasswordCipher.getInstance(cipherType);
                if (cipherType != null && (maySavePassword = !"simple".equals(cipherType) ? true : DefaultSVNAuthenticationManager.this.isStorePlainTextPasswords(realm, auth))) {
                    values.put("passtype", cipherType);
                }
            }
            SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
            if (maySavePassword) {
                values.put("password", cipher.encrypt(sshAuth.getPassword()));
            }
            int port = sshAuth.getPortNumber();
            if (sshAuth.getPortNumber() < 0) {
                port = DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber();
            }
            values.put("port", Integer.toString(port));
            if (sshAuth.getPrivateKeyFile() != null) {
                String path = sshAuth.getPrivateKeyFile().getAbsolutePath();
                if (maySavePassword) {
                    values.put("passphrase", cipher.encrypt(sshAuth.getPassphrase()));
                }
                values.put("key", path);
            }
        }

        private void saveSSLCredential(Map values, SVNAuthentication auth, String realm) throws SVNException {
            boolean storePassphrases = DefaultSVNAuthenticationManager.this.isStoreSSLClientCertificatePassphrases(auth.getURL());
            boolean maySavePassphrase = false;
            SVNPasswordCipher cipher = null;
            if (storePassphrases) {
                String cipherType = SVNPasswordCipher.getDefaultCipherType();
                cipher = SVNPasswordCipher.getInstance(cipherType);
                if (cipherType != null && (maySavePassphrase = !"simple".equals(cipherType) ? true : DefaultSVNAuthenticationManager.this.isStorePlainTextPassphrases(realm, auth))) {
                    values.put("passtype", cipherType);
                }
            }
            SVNSSLAuthentication sslAuth = (SVNSSLAuthentication)auth;
            if (maySavePassphrase) {
                values.put("passphrase", cipher.encrypt(sslAuth.getPassword()));
            }
            if (sslAuth.getCertificateFile() != null) {
                String path = sslAuth.getCertificateFile().getAbsolutePath();
                values.put("key", path);
            }
        }
    }

    public static interface IPersistentAuthenticationProvider {
        public void saveAuthentication(SVNAuthentication var1, String var2, String var3) throws SVNException;
    }

    private class CacheAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private CacheAuthenticationProvider() {
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            return (SVNAuthentication)DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().getData(kind, realm);
        }

        public void saveAuthentication(SVNAuthentication auth, String realm) {
            if (auth == null || realm == null) {
                return;
            }
            String kind = auth.getKind();
            DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().putData(kind, realm, auth);
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }

    protected class DumbAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private String myUserName;
        private String myPassword;
        private boolean myIsStore;
        private String myPassphrase;
        private File myPrivateKey;

        public DumbAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean store) {
            this.myUserName = userName;
            this.myPassword = password;
            this.myPrivateKey = privateKey;
            this.myPassphrase = passphrase;
            this.myIsStore = store;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            if (previousAuth == null) {
                if ("svn.ssh".equals(kind)) {
                    SVNSSHAuthentication sshAuth = DefaultSVNAuthenticationManager.this.getDefaultSSHAuthentication();
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        return sshAuth;
                    }
                    if (this.myPrivateKey != null) {
                        return new SVNSSHAuthentication(this.myUserName, this.myPrivateKey, this.myPassphrase, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore, url, false);
                    }
                    return new SVNSSHAuthentication(this.myUserName, this.myPassword, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore, url, false);
                }
                if ("svn.simple".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        String defaultUserName = DefaultSVNAuthenticationManager.this.getUserName(url);
                        String string = defaultUserName = defaultUserName == null ? System.getProperty("user.name") : defaultUserName;
                        if (defaultUserName != null) {
                            SVNPasswordAuthentication partialAuth = new SVNPasswordAuthentication(defaultUserName, null, false, null, true);
                            return partialAuth;
                        }
                        return null;
                    }
                    if (this.myPassword == null) {
                        return new SVNPasswordAuthentication(this.myUserName, null, false, null, true);
                    }
                    return new SVNPasswordAuthentication(this.myUserName, this.myPassword, this.myIsStore, url, false);
                }
                if ("svn.username".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName)) {
                        String userName = System.getProperty("svnkit.ssh2.author", System.getProperty("javasvn.ssh2.author"));
                        if (userName != null) {
                            return new SVNUserNameAuthentication(userName, this.myIsStore, url, false);
                        }
                        return null;
                    }
                    return new SVNUserNameAuthentication(this.myUserName, this.myIsStore, url, false);
                }
            }
            return null;
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }
}

