/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.util.regex.Pattern;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.desc.AttributeDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.exception.IdentityNotSupportedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.exception.SequenceNotSupportedRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.meta.DbColumnMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDescFactoryImpl
implements AttributeDescFactory {
    protected PersistenceConvention persistenceConvention;
    protected GenDialect dialect;
    protected Pattern versionColumnNamePattern;
    protected GenerationType generationType;
    protected int initialValue;
    protected int allocationSize;

    public AttributeDescFactoryImpl(PersistenceConvention persistenceConvention, GenDialect dialect, String versionColumnNamePattern, GenerationType generationType, Integer initialValue, Integer allocationSize) {
        if (persistenceConvention == null) {
            throw new NullPointerException("persistenceConvention");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (versionColumnNamePattern == null) {
            throw new NullPointerException("versionColumnNamePattern");
        }
        this.persistenceConvention = persistenceConvention;
        this.dialect = dialect;
        this.versionColumnNamePattern = Pattern.compile(versionColumnNamePattern, 2);
        GenerationType generationType2 = this.generationType = generationType == GenerationType.AUTO ? dialect.getDefaultGenerationType() : generationType;
        if (this.generationType == GenerationType.IDENTITY) {
            if (!dialect.supportsIdentity()) {
                throw new IdentityNotSupportedRuntimeException();
            }
        } else if (this.generationType == GenerationType.SEQUENCE) {
            if (!dialect.supportsSequence()) {
                throw new SequenceNotSupportedRuntimeException();
            }
            SequenceGenerator generator = AnnotationUtil.getDefaultSequenceGenerator();
            this.initialValue = initialValue != null ? initialValue.intValue() : generator.initialValue();
            this.allocationSize = allocationSize != null ? allocationSize.intValue() : generator.allocationSize();
        } else if (this.generationType == GenerationType.TABLE) {
            TableGenerator generator = AnnotationUtil.getDefaultTableGenerator();
            this.initialValue = initialValue != null ? initialValue.intValue() : generator.initialValue();
            this.allocationSize = allocationSize != null ? allocationSize.intValue() : generator.allocationSize();
        }
    }

    @Override
    public AttributeDesc getAttributeDesc(DbTableMeta tableMeta, DbColumnMeta columnMeta) {
        AttributeDesc attributeDesc = new AttributeDesc();
        this.doName(tableMeta, columnMeta, attributeDesc);
        this.doId(tableMeta, columnMeta, attributeDesc);
        this.doTransient(tableMeta, columnMeta, attributeDesc);
        this.doColumn(tableMeta, columnMeta, attributeDesc);
        this.doVersion(tableMeta, columnMeta, attributeDesc);
        this.doGenerationType(tableMeta, columnMeta, attributeDesc);
        return attributeDesc;
    }

    protected void doName(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
        attributeDesc.setName(this.persistenceConvention.fromColumnNameToPropertyName(columnMeta.getName()));
    }

    protected void doId(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
        if (columnMeta.isPrimaryKey()) {
            attributeDesc.setId(true);
        }
    }

    protected void doTransient(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
    }

    protected void doVersion(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
        if (this.isVersionAnnotatable(attributeDesc.getAttributeClass()) && this.versionColumnNamePattern.matcher(columnMeta.getName()).matches()) {
            attributeDesc.setVersion(true);
        }
    }

    protected void doColumn(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
        attributeDesc.setColumnName(columnMeta.getName());
        attributeDesc.setColumnTypeName(columnMeta.getTypeName());
        attributeDesc.setLength(columnMeta.getLength());
        attributeDesc.setPrecision(columnMeta.getLength());
        attributeDesc.setScale(columnMeta.getScale());
        attributeDesc.setNullable(columnMeta.isNullable());
        attributeDesc.setUnique(columnMeta.isUnique());
        attributeDesc.setComment(columnMeta.getComment());
        GenDialect.ColumnType columnType = this.dialect.getColumnType(columnMeta.getTypeName(), columnMeta.getSqlType());
        if (columnType != null) {
            Class<?> clazz = columnType.getAttributeClass(columnMeta.getLength(), columnMeta.getLength(), columnMeta.getScale());
            attributeDesc.setAttributeClass(clazz);
            String defaultValue = attributeDesc.isId() ? null : columnMeta.getDefaultValue();
            String definition = columnType.getColumnDefinition(columnMeta.getLength(), columnMeta.getLength(), columnMeta.getScale(), defaultValue);
            attributeDesc.setColumnDefinition(definition);
            attributeDesc.setLob(columnType.isLob());
            attributeDesc.setPrimaryTemporalType(columnType.getTemporalType());
        } else {
            attributeDesc.setUnsupportedColumnType(true);
            attributeDesc.setAttributeClass(String.class);
            attributeDesc.setLob(false);
        }
    }

    protected void doGenerationType(DbTableMeta tableMeta, DbColumnMeta columnMeta, AttributeDesc attributeDesc) {
        Class clazz;
        if (columnMeta.isPrimaryKey() && !tableMeta.hasCompositePrimaryKey() && Number.class.isAssignableFrom(clazz = ClassUtil.getWrapperClassIfPrimitive(attributeDesc.getAttributeClass()))) {
            if (columnMeta.isAutoIncrement()) {
                attributeDesc.setGenerationType(GenerationType.IDENTITY);
            } else {
                attributeDesc.setGenerationType(this.generationType);
                attributeDesc.setInitialValue(this.initialValue);
                attributeDesc.setAllocationSize(this.allocationSize);
            }
        }
    }

    protected boolean isVersionAnnotatable(Class<?> clazz) {
        Class wrapperClass = ClassUtil.getWrapperClassIfPrimitive(clazz);
        return wrapperClass == Integer.class || wrapperClass == Long.class;
    }
}

