/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbForeignKeyMeta {
    protected String name;
    protected String primaryKeyCatalogName;
    protected String primaryKeySchemaName;
    protected String primaryKeyTableName;
    protected List<String> primaryKeyColumnNameList = new ArrayList<String>();
    protected List<String> foreignKeyColumnNameList = new ArrayList<String>();
    protected boolean unique;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrimaryKeyCatalogName() {
        return this.primaryKeyCatalogName;
    }

    public void setPrimaryKeyCatalogName(String primaryKeyCatalogName) {
        this.primaryKeyCatalogName = primaryKeyCatalogName;
    }

    public String getPrimaryKeySchemaName() {
        return this.primaryKeySchemaName;
    }

    public void setPrimaryKeySchemaName(String primaryKeySchemaName) {
        this.primaryKeySchemaName = primaryKeySchemaName;
    }

    public String getPrimaryKeyTableName() {
        return this.primaryKeyTableName;
    }

    public void setPrimaryKeyTableName(String primaryKeyTableName) {
        this.primaryKeyTableName = primaryKeyTableName;
    }

    public List<String> getPrimaryKeyColumnNameList() {
        return Collections.unmodifiableList(this.primaryKeyColumnNameList);
    }

    public void addPrimaryKeyColumnName(String primaryKeyColumnName) {
        this.primaryKeyColumnNameList.add(primaryKeyColumnName);
    }

    public List<String> getForeignKeyColumnNameList() {
        return Collections.unmodifiableList(this.foreignKeyColumnNameList);
    }

    public void addForeignKeyColumnName(String foreignKeyColumnName) {
        this.foreignKeyColumnNameList.add(foreignKeyColumnName);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getPrimaryKeyFullTableName() {
        StringBuilder buf = new StringBuilder();
        if (this.primaryKeyCatalogName != null) {
            buf.append(this.primaryKeyCatalogName).append(".");
        }
        if (this.primaryKeySchemaName != null) {
            buf.append(this.primaryKeySchemaName).append(".");
        }
        return buf.append(this.primaryKeyTableName).toString();
    }

    public boolean isComposite() {
        return this.foreignKeyColumnNameList.size() > 1;
    }
}

