/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.exception.NoResultRuntimeException;
import org.seasar.extension.jdbc.gen.version.SchemaInfoTable;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class SchemaInfoTableImpl
implements SchemaInfoTable {
    protected static Logger logger = Logger.getLogger(SchemaInfoTableImpl.class);
    protected DataSource dataSource;
    protected GenDialect dialect;
    protected String fullTableName;
    protected String columnName;
    protected String selectSql;
    protected String createSql;
    protected String deleteSql;
    protected String insertSql;

    public SchemaInfoTableImpl(DataSource dataSource, GenDialect dialect, String fullTableName, String columnName) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (fullTableName == null) {
            throw new NullPointerException("fullTableName");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName");
        }
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.fullTableName = fullTableName;
        this.columnName = columnName;
        this.selectSql = this.createSelectSql();
        this.insertSql = this.createInsertSql();
        this.deleteSql = this.createDeleteSql();
        this.createSql = this.createCreateSql();
    }

    protected String createSelectSql() {
        return "select " + this.columnName + " from " + this.fullTableName;
    }

    protected String createInsertSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into ");
        buf.append(this.fullTableName);
        buf.append(" (");
        buf.append(this.columnName);
        buf.append(") values (?)");
        return buf.toString();
    }

    protected String createDeleteSql() {
        return "delete from " + this.fullTableName;
    }

    protected String createCreateSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("create table ");
        buf.append(this.fullTableName);
        buf.append(" (");
        buf.append(this.columnName);
        buf.append(" ");
        buf.append(this.dialect.getSqlType(4).getDataType(0, 10, 0, false));
        buf.append(")");
        return buf.toString();
    }

    public int getVersionNo() {
        if (!this.exists()) {
            return 0;
        }
        return this.getVersionNoInternal();
    }

    protected int getVersionNoInternal() {
        Connection conn = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            logger.debug((Object)this.selectSql);
            PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)conn, (String)this.selectSql);
            try {
                ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
                try {
                    if (rs.next()) {
                        int n = rs.getInt(1);
                        return n;
                    }
                    try {
                        throw new NoResultRuntimeException(this.fullTableName);
                    }
                    catch (SQLException e) {
                        throw new SQLRuntimeException(e);
                    }
                }
                finally {
                    ResultSetUtil.close((ResultSet)rs);
                }
            }
            finally {
                StatementUtil.close((Statement)ps);
            }
        }
        finally {
            ConnectionUtil.close((Connection)conn);
        }
    }

    public void setVersionNo(int versionNo) {
        if (!this.exists()) {
            this.create();
        }
        this.setVersionNoInternal(versionNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVersionNoInternal(int versionNo) {
        Connection conn = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            logger.debug((Object)this.deleteSql);
            PreparedStatement delete = ConnectionUtil.prepareStatement((Connection)conn, (String)this.deleteSql);
            try {
                PreparedStatementUtil.executeUpdate((PreparedStatement)delete);
            }
            finally {
                StatementUtil.close((Statement)delete);
            }
            logger.debug((Object)this.insertSql.replace("?", Integer.toString(versionNo)));
            PreparedStatement insert = ConnectionUtil.prepareStatement((Connection)conn, (String)this.insertSql);
            try {
                insert.setInt(1, versionNo);
                PreparedStatementUtil.executeUpdate((PreparedStatement)insert);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
            finally {
                StatementUtil.close((Statement)insert);
            }
        }
        finally {
            ConnectionUtil.close((Connection)conn);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean exists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() {
        Connection conn = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            logger.debug((Object)this.createSql);
            PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)conn, (String)this.createSql);
            try {
                PreparedStatementUtil.execute((PreparedStatement)ps);
            }
            finally {
                StatementUtil.close((Statement)ps);
            }
        }
        finally {
            ConnectionUtil.close((Connection)conn);
        }
    }
}

