/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.seasar.extension.jdbc.gen.internal.exception.IllegalDdlInfoVersionRuntimeException;
import org.seasar.extension.jdbc.gen.internal.exception.NextVersionExceededRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.version.DdlInfoFile;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;

public class DdlInfoFileImpl
implements DdlInfoFile {
    protected static Logger logger = Logger.getLogger(DdlInfoFileImpl.class);
    protected static final String ENCODING = "UTF-8";
    protected File file;
    protected Integer versionNo;

    public DdlInfoFileImpl(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
    }

    public int getCurrentVersionNo() {
        return this.getCurrentVersionNoInternal();
    }

    protected int getCurrentVersionNoInternal() {
        if (this.versionNo != null) {
            return this.versionNo;
        }
        if (!this.file.exists()) {
            logger.log("IS2JDBCGen0003", new Object[]{this.file.getPath()});
            this.versionNo = 0;
            return this.versionNo;
        }
        String line = this.readLine();
        if (line == null) {
            logger.log("IS2JDBCGen0007", new Object[]{this.file.getPath()});
            this.versionNo = 0;
            return this.versionNo;
        }
        int pos = line.indexOf("=");
        String value = pos > -1 ? line.substring(0, pos) : line;
        this.versionNo = this.convertToInt(value.trim());
        return this.versionNo;
    }

    protected String readLine() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), ENCODING));
            return reader.readLine();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public int getNextVersionNo() {
        return this.getNextVersionNoInternal();
    }

    protected int getNextVersionNoInternal() {
        long nextVersionNo = (long)this.getCurrentVersionNoInternal() + 1L;
        if (nextVersionNo > Integer.MAX_VALUE) {
            throw new NextVersionExceededRuntimeException(this.file.getPath());
        }
        return (int)nextVersionNo;
    }

    public void applyNextVersionNo(String comment) {
        File temp = null;
        if (this.file.exists()) {
            temp = FileUtil.createTempFile("ddl-info", null);
            temp.deleteOnExit();
            FileUtil.copy(this.file, temp);
        }
        this.writeLine(this.getNextVersionNoInternal() + "=" + comment);
        if (temp != null) {
            FileUtil.append(temp, this.file);
        }
        this.versionNo = null;
    }

    protected void writeLine(String line) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING));
            writer.write(line);
            writer.newLine();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(writer);
                throw throwable;
            }
        }
        CloseableUtil.close(writer);
    }

    protected int convertToInt(String value) {
        int versionNo;
        try {
            versionNo = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalDdlInfoVersionRuntimeException(this.file.getPath(), value);
        }
        if (versionNo < 0) {
            throw new IllegalDdlInfoVersionRuntimeException(this.file.getPath(), value);
        }
        return versionNo;
    }
}

