/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Generated;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.seasar.extension.jdbc.gen.desc.AssociationDesc;
import org.seasar.extension.jdbc.gen.desc.AssociationType;
import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.desc.CompositeUniqueConstraintDesc;
import org.seasar.extension.jdbc.gen.desc.EntityDesc;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.AssociationModel;
import org.seasar.extension.jdbc.gen.model.AssociationModelFactory;
import org.seasar.extension.jdbc.gen.model.AttributeModel;
import org.seasar.extension.jdbc.gen.model.AttributeModelFactory;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.CompositeUniqueConstraintModel;
import org.seasar.extension.jdbc.gen.model.CompositeUniqueConstraintModelFactory;
import org.seasar.extension.jdbc.gen.model.EntityModel;
import org.seasar.extension.jdbc.gen.model.EntityModelFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityModelFactoryImpl
implements EntityModelFactory {
    protected String packageName;
    protected AttributeModelFactory attributeModelFactory;
    protected AssociationModelFactory associationModelFactory;
    protected CompositeUniqueConstraintModelFactory compositeUniqueConstraintModelFactory;
    protected boolean useAccessor;
    protected boolean useComment;
    protected boolean showCatalogName;
    protected boolean showSchemaName;
    protected boolean showTableName;
    protected Class<?> superclass;
    protected BeanDesc mappedSuperclassBeanDesc;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public EntityModelFactoryImpl(String packageName, Class<?> superclass, AttributeModelFactory attributeModelFactory, AssociationModelFactory associationModelFactory, CompositeUniqueConstraintModelFactory compositeUniqueConstraintModelFactory, boolean useAccessor, boolean useComment, boolean showCatalogName, boolean showSchemaName, boolean showTableName) {
        if (attributeModelFactory == null) {
            throw new NullPointerException("attributeModelFactory");
        }
        if (associationModelFactory == null) {
            throw new NullPointerException("associationModelFactory");
        }
        if (compositeUniqueConstraintModelFactory == null) {
            throw new NullPointerException("compositeUniqueConstraintModelFactory");
        }
        this.packageName = packageName;
        this.superclass = superclass;
        this.attributeModelFactory = attributeModelFactory;
        this.associationModelFactory = associationModelFactory;
        this.compositeUniqueConstraintModelFactory = compositeUniqueConstraintModelFactory;
        this.useAccessor = useAccessor;
        this.useComment = useComment;
        this.showCatalogName = showCatalogName;
        this.showSchemaName = showSchemaName;
        this.showTableName = showTableName;
        if (superclass != null && superclass.isAnnotationPresent(MappedSuperclass.class)) {
            this.mappedSuperclassBeanDesc = BeanDescFactory.getBeanDesc(superclass);
        }
    }

    @Override
    public EntityModel getEntityModel(EntityDesc entityDesc) {
        EntityModel entityModel = new EntityModel();
        if (this.showCatalogName) {
            entityModel.setCatalogName(entityDesc.getCatalogName());
        }
        if (this.showSchemaName) {
            entityModel.setSchemaName(entityDesc.getSchemaName());
        }
        if (this.showTableName) {
            entityModel.setTableName(entityDesc.getTableName());
        }
        entityModel.setPackageName(this.packageName);
        entityModel.setShortClassName(entityDesc.getName());
        if (this.superclass != null) {
            entityModel.setShortSuperclassName(this.superclass.getSimpleName());
        }
        entityModel.setCompositeId(entityDesc.hasCompositeId());
        entityModel.setUseAccessor(this.useAccessor);
        entityModel.setComment(entityDesc.getComment());
        entityModel.setUseComment(this.useComment);
        this.doAttributeModel(entityModel, entityDesc);
        this.doAssociationModel(entityModel, entityDesc);
        this.doCompositeUniqueConstraintModel(entityModel, entityDesc);
        this.doImportName(entityModel, entityDesc);
        this.doGeneratedInfo(entityModel, entityDesc);
        return entityModel;
    }

    protected void doAttributeModel(EntityModel entityModel, EntityDesc entityDesc) {
        for (AttributeDesc attributeDesc : entityDesc.getAttributeDescList()) {
            if (this.mappedSuperclassBeanDesc != null && this.mappedSuperclassBeanDesc.hasField(attributeDesc.getName())) continue;
            AttributeModel attributeModel = this.attributeModelFactory.getAttributeModel(attributeDesc);
            entityModel.addAttributeModel(attributeModel);
        }
    }

    protected void doAssociationModel(EntityModel entityModel, EntityDesc entityDesc) {
        for (AssociationDesc associationDesc : entityDesc.getAssociationDescList()) {
            if (this.mappedSuperclassBeanDesc != null && this.mappedSuperclassBeanDesc.hasField(associationDesc.getName())) continue;
            AssociationModel associationModel = this.associationModelFactory.getAssociationModel(associationDesc);
            entityModel.addAssociationModel(associationModel);
        }
    }

    protected void doCompositeUniqueConstraintModel(EntityModel entityModel, EntityDesc entityDesc) {
        for (CompositeUniqueConstraintDesc compositeUniqueConstraintDesc : entityDesc.getCompositeUniqueConstraintDescList()) {
            CompositeUniqueConstraintModel compositeUniqueConstraintModel = this.compositeUniqueConstraintModelFactory.getUniqueConstraintModel(compositeUniqueConstraintDesc);
            entityModel.addCompositeUniqueConstraintModel(compositeUniqueConstraintModel);
        }
    }

    protected void doImportName(EntityModel model, EntityDesc entityDesc) {
        this.classModelSupport.addImportName((ClassModel)model, Entity.class);
        this.classModelSupport.addImportName((ClassModel)model, Serializable.class);
        this.classModelSupport.addImportName((ClassModel)model, Generated.class);
        if (model.getCatalogName() != null || model.getSchemaName() != null || model.getTableName() != null) {
            this.classModelSupport.addImportName((ClassModel)model, Table.class);
        }
        if (this.superclass != null) {
            this.classModelSupport.addImportName((ClassModel)model, this.superclass);
        }
        for (AttributeModel attr : model.getAttributeModelList()) {
            if (attr.isId()) {
                this.classModelSupport.addImportName((ClassModel)model, Id.class);
                if (attr.getGenerationType() != null) {
                    this.classModelSupport.addImportName((ClassModel)model, GeneratedValue.class);
                    this.classModelSupport.addImportName((ClassModel)model, GenerationType.class);
                    if (attr.getGenerationType() == GenerationType.SEQUENCE) {
                        this.classModelSupport.addImportName((ClassModel)model, SequenceGenerator.class);
                    } else if (attr.getGenerationType() == GenerationType.TABLE) {
                        this.classModelSupport.addImportName((ClassModel)model, TableGenerator.class);
                    }
                }
            }
            if (attr.isLob()) {
                this.classModelSupport.addImportName((ClassModel)model, Lob.class);
            }
            if (attr.getTemporalType() != null) {
                this.classModelSupport.addImportName((ClassModel)model, Temporal.class);
                this.classModelSupport.addImportName((ClassModel)model, TemporalType.class);
            }
            if (attr.isTransient()) {
                this.classModelSupport.addImportName((ClassModel)model, Transient.class);
            } else {
                this.classModelSupport.addImportName((ClassModel)model, Column.class);
            }
            if (attr.isVersion()) {
                this.classModelSupport.addImportName((ClassModel)model, Version.class);
            }
            this.classModelSupport.addImportName((ClassModel)model, attr.getAttributeClass());
        }
        for (AssociationModel asso : model.getAssociationModelList()) {
            AssociationType associationType = asso.getAssociationType();
            if (associationType == AssociationType.ONE_TO_MANY) {
                this.classModelSupport.addImportName((ClassModel)model, List.class);
            }
            this.classModelSupport.addImportName((ClassModel)model, associationType.getAnnotation());
            if (asso.getJoinColumnModel() != null) {
                this.classModelSupport.addImportName((ClassModel)model, JoinColumn.class);
            }
            if (asso.getJoinColumnsModel() == null) continue;
            this.classModelSupport.addImportName((ClassModel)model, JoinColumn.class);
            this.classModelSupport.addImportName((ClassModel)model, JoinColumns.class);
        }
        if (!model.getCompositeUniqueConstraintModelList().isEmpty()) {
            this.classModelSupport.addImportName((ClassModel)model, Table.class);
            this.classModelSupport.addImportName((ClassModel)model, UniqueConstraint.class);
        }
    }

    protected void doGeneratedInfo(EntityModel entityModel, EntityDesc entityDesc) {
        this.generatedModelSupport.fillGeneratedInfo(this, entityModel);
    }
}

