/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version.wrapper;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.event.GenDdlEvent;
import org.seasar.extension.jdbc.gen.event.GenDdlListener;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.ManagedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFileWrapper
implements ManagedFile {
    protected ManagedFile parent;
    protected ManagedFile target;
    protected GenDdlListener genDdlListener;
    protected DdlVersionDirectory currentVersionDir;
    protected DdlVersionDirectory nextVersionDir;

    protected ManagedFileWrapper(ManagedFile target, GenDdlListener genDdlListener, DdlVersionDirectory currentVersionDir, DdlVersionDirectory nextVersionDir) {
        this(null, target, genDdlListener, currentVersionDir, nextVersionDir);
    }

    protected ManagedFileWrapper(ManagedFile parent, ManagedFile target, GenDdlListener genDdlListener, DdlVersionDirectory currentVersionDir, DdlVersionDirectory nextVersionDir) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (genDdlListener == null) {
            throw new NullPointerException("genDdlListener");
        }
        if (currentVersionDir == null) {
            throw new NullPointerException("currentVersionDir");
        }
        if (nextVersionDir == null) {
            throw new NullPointerException("nextVersionDir");
        }
        this.parent = parent;
        this.target = target;
        this.genDdlListener = genDdlListener;
        this.currentVersionDir = currentVersionDir;
        this.nextVersionDir = nextVersionDir;
    }

    @Override
    public File asFile() {
        return this.getManagedFile().asFile();
    }

    @Override
    public ManagedFile createChild(String relativePath) {
        ManagedFile file = this.getManagedFile().createChild(relativePath);
        return this.wrap(file);
    }

    @Override
    public boolean delete() {
        return this.getManagedFile().delete();
    }

    @Override
    public boolean createNewFile() {
        if (this.getManagedFile().exists()) {
            return false;
        }
        this.mkdirs(this.parent);
        GenDdlEvent event = new GenDdlEvent(this, this.currentVersionDir, this.nextVersionDir, this.getManagedFile().getRelativePath());
        this.genDdlListener.preCreateTargetFile(event);
        boolean made = this.getManagedFile().createNewFile();
        if (made) {
            this.genDdlListener.postCreateTargetFile(event);
        }
        return made;
    }

    @Override
    public ManagedFile getParent() {
        return this.parent;
    }

    @Override
    public boolean mkdir() {
        if (this.getManagedFile().exists()) {
            return false;
        }
        GenDdlEvent event = new GenDdlEvent(this, this.currentVersionDir, this.nextVersionDir, this.getManagedFile().getRelativePath());
        this.genDdlListener.preCreateTargetFile(event);
        boolean made = this.getManagedFile().mkdir();
        if (made) {
            this.genDdlListener.postCreateTargetFile(event);
        }
        return made;
    }

    @Override
    public boolean mkdirs() {
        return this.mkdirs(this);
    }

    protected boolean mkdirs(ManagedFile file) {
        File parentFile;
        ManagedFile parent = file.getParent();
        if (parent == null ? !(parentFile = file.asFile().getParentFile()).exists() && !parentFile.mkdirs() : !parent.exists() && !this.mkdirs(parent)) {
            return false;
        }
        return file.mkdir();
    }

    @Override
    public boolean exists() {
        return this.getManagedFile().exists();
    }

    @Override
    public String getName() {
        return this.getManagedFile().getName();
    }

    @Override
    public String getRelativePath() {
        return this.getManagedFile().getRelativePath();
    }

    @Override
    public boolean isDirectory() {
        return this.getManagedFile().isDirectory();
    }

    @Override
    public List<File> listAllFiles() {
        return this.getManagedFile().listAllFiles();
    }

    @Override
    public List<ManagedFile> listManagedFiles() {
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>();
        for (ManagedFile file : this.getManagedFile().listManagedFiles()) {
            list.add(this.wrap(file));
        }
        return list;
    }

    @Override
    public List<ManagedFile> listManagedFiles(FilenameFilter filter) {
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>();
        for (ManagedFile file : this.getManagedFile().listManagedFiles(filter)) {
            list.add(this.wrap(file));
        }
        return list;
    }

    @Override
    public boolean hasChild() {
        return this.getManagedFile().hasChild();
    }

    protected ManagedFile getManagedFile() {
        return this.target;
    }

    protected ManagedFile wrap(ManagedFile target) {
        return new ManagedFileWrapper(this, target, this.genDdlListener, this.currentVersionDir, this.nextVersionDir);
    }
}

