/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.HeaderRecord;

public class HSSFHeader {
    HeaderRecord headerRecord;
    String left;
    String center;
    String right;

    protected HSSFHeader(HeaderRecord headerRecord) {
        this.headerRecord = headerRecord;
        String head = headerRecord.getHeader();
        block5: while (head != null && head.length() > 1) {
            int pos = head.length();
            switch (head.substring(1, 2).charAt(0)) {
                case 'L': {
                    if (head.indexOf("&C") >= 0) {
                        pos = Math.min(pos, head.indexOf("&C"));
                    }
                    if (head.indexOf("&R") >= 0) {
                        pos = Math.min(pos, head.indexOf("&R"));
                    }
                    this.left = head.substring(2, pos);
                    head = head.substring(pos);
                    continue block5;
                }
                case 'C': {
                    if (head.indexOf("&L") >= 0) {
                        pos = Math.min(pos, head.indexOf("&L"));
                    }
                    if (head.indexOf("&R") >= 0) {
                        pos = Math.min(pos, head.indexOf("&R"));
                    }
                    this.center = head.substring(2, pos);
                    head = head.substring(pos);
                    continue block5;
                }
                case 'R': {
                    if (head.indexOf("&C") >= 0) {
                        pos = Math.min(pos, head.indexOf("&C"));
                    }
                    if (head.indexOf("&L") >= 0) {
                        pos = Math.min(pos, head.indexOf("&L"));
                    }
                    this.right = head.substring(2, pos);
                    head = head.substring(pos);
                    continue block5;
                }
            }
            head = null;
        }
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String newLeft) {
        this.left = newLeft;
        this.createHeaderString();
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String newCenter) {
        this.center = newCenter;
        this.createHeaderString();
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String newRight) {
        this.right = newRight;
        this.createHeaderString();
    }

    private void createHeaderString() {
        this.headerRecord.setHeader("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.headerRecord.setHeaderLength((byte)this.headerRecord.getHeader().length());
    }

    public static String fontSize(short size) {
        return "&" + size;
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String page() {
        return "&P";
    }

    public static String numPages() {
        return "&N";
    }

    public static String date() {
        return "&D";
    }

    public static String time() {
        return "&T";
    }

    public static String file() {
        return "&F";
    }

    public static String tab() {
        return "&A";
    }

    public static String startUnderline() {
        return "&U";
    }

    public static String endUnderline() {
        return "&U";
    }

    public static String startDoubleUnderline() {
        return "&E";
    }

    public static String endDoubleUnderline() {
        return "&E";
    }
}

