/*
 * Copyright 2006-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.maven.dao;

import java.util.List;

import org.seasar.codegen.maven.entity.DeptTable;
import org.seasar.codegen.maven.condition.DeptTableCondition;
/**
 * DEPT_TABLEテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはDeptTableDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = DeptTable.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface DeptTableCore {

	/**
	 * DEPT_TABLEのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY DEPT_ID")
	public List<DeptTable> getAllDeptTable();


	/**
	 * 引数が主キーと一致するDEPT_TABLEのEntityを取得します。
	 *
	 * @param deptId 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("DEPT_ID = ?")
	public DeptTable getDeptTable(Integer deptId);


	/**
	 * 引数が主キーと一致するDEPT_TABLEのEntityのリストを主キーでソートして取得します。
	 *
	 * @param deptIds  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("deptIds")
	@org.seasar.dao.annotation.tiger.Query("DEPT_ID in /*deptIds*/(1) ORDER BY DEPT_ID")
	public List<DeptTable> getDeptTableByIds(Integer ... deptIds);
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<DeptTable> find(DeptTableCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public DeptTable soleMatch(DeptTableCondition condition);

	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(DeptTable entity);
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(DeptTable entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(DeptTable entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(DeptTable entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(DeptTable entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(DeptTable entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<DeptTable> entityList);
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<DeptTable> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<DeptTable> entityList);

}

