/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.maven;

import java.io.File;
import java.util.Map;

import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.seasar.codegen.ant.DirectoryList;
import org.seasar.codegen.impl.CodeGenConfigImpl;
import org.seasar.codegen.maven.CodegenMojo.ClassConfig;
import org.seasar.codegen.maven.CodegenMojo.DatabaseConfig;

public class CodegenMojoTest extends AbstractMojoTestCase {

    public void testPom() throws Exception {
        File testPom = new File(getBasedir(),
                "src/test/resources/org/seasar/codegen/maven/pom.xml");
        CodegenMojo mojo = (CodegenMojo) lookupMojo("generate", testPom);
        String javaDir = (String) getVariablesAndValuesFromObject(mojo).get(
                "javaDir");
        assertEquals("src/main/java", javaDir);
        String resourceDir = (String) getVariablesAndValuesFromObject(mojo)
                .get("resourceDir");
        assertEquals("src/main/resources", resourceDir);
        String ddlDir = (String) getVariablesAndValuesFromObject(mojo).get(
                "ddlDir");
        assertEquals("src/main/ddl", ddlDir);
        String headerTemplatePath = (String) getVariablesAndValuesFromObject(
                mojo).get("headerTemplatePath");
        assertEquals("test/header.txt", headerTemplatePath);
        String versionNoPropertyName = (String) getVariablesAndValuesFromObject(
                mojo).get("versionNoPropertyName");
        assertEquals("versionNo", versionNoPropertyName);
        String timestampPropertyName = (String) getVariablesAndValuesFromObject(
                mojo).get("timestampPropertyName");
        assertEquals("timestamp", timestampPropertyName);
        String identityType = (String) getVariablesAndValuesFromObject(mojo)
                .get("identityType");
        assertEquals("identity", identityType);
        boolean outputAllDaoDicon = (Boolean) getVariablesAndValuesFromObject(
                mojo).get("outputAllDaoDicon");
        assertTrue(outputAllDaoDicon);
        boolean outputDDL = (Boolean) getVariablesAndValuesFromObject(mojo)
                .get("outputDDL");
        assertTrue(outputDDL);
        String encoding = (String) getVariablesAndValuesFromObject(mojo).get(
                "encoding");
        assertEquals("Windows-31J", encoding);
        String packageName = (String) getVariablesAndValuesFromObject(mojo)
                .get("packageName");
        assertEquals("org.seasar.codegen.mvn", packageName);
        String importCodeDataClass = (String) getVariablesAndValuesFromObject(
                mojo).get("importCodeDataClass");
        assertEquals("org.seasar.codegen.impl.ExcelImportCodeDataSingleSheet",
                importCodeDataClass);
        String dbClass = (String) getVariablesAndValuesFromObject(mojo).get(
                "dbClass");
        assertEquals("org.seasar.codegen.dbms.H2", dbClass);
        String[] tableNames = (String[]) getVariablesAndValuesFromObject(mojo)
                .get("tableNames");
        assertEquals("EMP", tableNames[0]);
        assertEquals("DEPT", tableNames[1]);

        @SuppressWarnings("rawtypes")
        Map sequnceMapping = (Map) getVariablesAndValuesFromObject(mojo).get(
                "sequenceMapping");
        assertEquals("empNo", sequnceMapping.get("EMP"));
    }

    public void testPom2() throws Exception {
        DirectoryList directoryList = new DirectoryList();
        directoryList.add("java", "test/main/java");
        directoryList.add("resource", "test/main/resources");
        directoryList.add("createtable", "test/main/ddl");

        CodeGenConfigImpl configImpl = new CodeGenConfigImpl();
        configImpl.setHeaderTemplatePath("src/test/resources/header.txt");
        configImpl.setVersionNoPropertyName("versionno");
        configImpl.setEncoding("UTF-8");
        configImpl
                .setInputFile("src/test/resources/org/seasar/codegen/maven/codegen.jiemamy");
        configImpl.setPackageName("org.seasar.codegen.maven");

        ClassConfig classConfig = new ClassConfig(
                "org.seasar.codegen.impl.JiemamyImportCodeData",
                "org.seasar.codegen.dbms.H2",
                "org.seasar.codegen.convert.impl.FKNameChildNameConverterImpl",
                "org.seasar.codegen.convert.impl.CamelConverterImpl");
        DatabaseConfig databaseConfig = new DatabaseConfig(null, null, null,
                null);

        new CodegenMojo().doExecute(directoryList, configImpl, classConfig,
                directoryList, databaseConfig);

    }
}
