/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.maven;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.DDL;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.Java;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.Resource;
import org.seasar.codegen.ant.Directory;
import org.seasar.codegen.ant.DirectoryList;
import org.seasar.codegen.ant.EachGen;
import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.impl.CodeGenConfigImpl;
import org.seasar.codegen.impl.DDLOutputCodeImpl;
import org.seasar.codegen.impl.DatabaseImportCodeData;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class CodegenMojo
extends AbstractMojo {
    private String javaDir;
    private String resourceDir;
    private String ddlDir;
    private String headerTemplatePath;
    private String versionNoPropertyName;
    private String timestampPropertyName;
    private String identityType;
    private boolean outputAllDaoDicon;
    private boolean outputDDL;
    private String encoding;
    private String inputFile;
    private String packageName;
    private String importCodeDataClass;
    private String dbClass;
    private String fkNameConverterClass;
    private String nameConverterClass;
    private String schemeName;
    private String[] tableNames;
    private String ignoreTablePattern;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private String driverGroupId;
    private String driverArtifactId;
    private String driverVersion;
    private String driverClassName;
    private String url;
    private String userName;
    private String password = "";
    private Map<String, String> sequenceMapping;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DirectoryList directoryList = new DirectoryList();
        directoryList.add("java", this.javaDir);
        directoryList.add("resource", this.resourceDir);
        directoryList.add("createtable", this.ddlDir);
        CodeGenConfigImpl configImpl = new CodeGenConfigImpl();
        configImpl.setHeaderTemplatePath(this.headerTemplatePath);
        configImpl.setVersionNoPropertyName(this.versionNoPropertyName);
        configImpl.setTimestampPropertyName(this.timestampPropertyName);
        configImpl.setIdentityType(this.identityType);
        configImpl.setOutputAllDaoDicon(this.outputAllDaoDicon);
        configImpl.setOutputDDL(this.outputDDL);
        configImpl.setEncoding(this.encoding);
        configImpl.setInputFile(this.inputFile);
        configImpl.setPackageName(this.packageName);
        System.out.println(this.sequenceMapping);
        if (this.sequenceMapping != null) {
            configImpl.setSequnceMapping(this.sequenceMapping);
        }
        ClassConfig classConfig = new ClassConfig(this.importCodeDataClass, this.dbClass, this.fkNameConverterClass, this.nameConverterClass);
        DataSourceImpl dataSource = null;
        if (this.driverClassName != null) {
            try {
                Artifact artifact = this.artifactFactory.createArtifact(this.driverGroupId, this.driverArtifactId, this.driverVersion, "compile", "jar");
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                dataSource = new DataSourceImpl(this.driverClassName, this.url, this.userName, this.password, artifact.getFile());
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        DatabaseConfig databaseConfig = new DatabaseConfig(this.schemeName, this.tableNames, this.ignoreTablePattern, dataSource);
        this.doExecute(directoryList, (CodeGenConfig)configImpl, classConfig, directoryList, databaseConfig);
    }

    void doExecute(DirectoryList list, CodeGenConfig codeGenConfig, ClassConfig classConfig, DirectoryList directoryList, DatabaseConfig databaseConfig) {
        S2Container s2 = S2ContainerFactory.create((String)"app_gen.dicon");
        this.doGenarate(codeGenConfig, classConfig, directoryList, databaseConfig, s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGenarate(CodeGenConfig codeGenConfig, ClassConfig classConfig, DirectoryList directory, DatabaseConfig databaseConfig, S2Container s2) {
        S2Container container = S2ContainerFactory.create();
        try {
            ComponentDefImpl def = new ComponentDefImpl(ClassUtil.forName((String)classConfig.getImportCodeDataClass()));
            container.register((ComponentDef)def);
            ComponentDefImpl defDbms = new ComponentDefImpl(ClassUtil.forName((String)classConfig.getDbClass()));
            container.register((ComponentDef)defDbms);
            ComponentDefImpl defFkName = new ComponentDefImpl(ClassUtil.forName((String)classConfig.getFkNameConverterClass()));
            container.register((ComponentDef)defFkName);
            ComponentDefImpl defNameConverter = new ComponentDefImpl(ClassUtil.forName((String)classConfig.getNameConverterClass()));
            container.register((ComponentDef)defNameConverter);
            container.register((Object)codeGenConfig);
            if (databaseConfig.isUse()) {
                container.register((Object)databaseConfig.getDataSource());
            }
            S2Container child = S2ContainerFactory.create((String)"CodeGen.dicon");
            child.init();
            container.include(child);
            container.init();
            s2.include(container);
            s2.init();
            ComponentDef[] components = s2.findAllComponentDefs(OutputCode.class);
            this.injectDatabaseProperty(s2.getComponent(ImportCodeData.class), databaseConfig);
            for (ComponentDef componentDef : components) {
                OutputCode outputCode = (OutputCode)componentDef.getComponent();
                outputCode.setCodegenConfig(codeGenConfig);
                outputCode.setNameConverter((NameConverter)container.getComponent(NameConverter.class));
                if (outputCode.getClass().isAnnotationPresent(Java.class)) {
                    this.doGenarate(codeGenConfig, classConfig, outputCode, directory.getDirectory("java"), s2);
                    continue;
                }
                if (outputCode.getClass().isAnnotationPresent(Resource.class)) {
                    this.doGenarate(codeGenConfig, classConfig, outputCode, directory.getDirectory("resource"), s2);
                    continue;
                }
                if (outputCode.getClass().isAnnotationPresent(DDL.class)) {
                    ((DDLOutputCodeImpl)outputCode).setDbms((Dbms)container.getComponent(Dbms.class));
                    this.doGenarate(codeGenConfig, classConfig, outputCode, directory.getDirectory("createtable"), s2);
                    continue;
                }
                throw new SRuntimeException("ECDG0003", new Object[]{outputCode.getClass()});
            }
        }
        finally {
            container.destroy();
        }
    }

    private void injectDatabaseProperty(Object component, DatabaseConfig databaseConfig) {
        if (component instanceof DatabaseImportCodeData) {
            DatabaseImportCodeData importCodeData = (DatabaseImportCodeData)component;
            importCodeData.setSchemaName(databaseConfig.getSchemeName());
            importCodeData.setIgnoreTablePattern(databaseConfig.getIgnoreTablePattern());
            for (String table : databaseConfig.getTableNames()) {
                importCodeData.addTable(table);
            }
        }
    }

    private void doGenarate(CodeGenConfig codeGenConfig, ClassConfig classConfig, OutputCode outputCode, Directory directory, S2Container s2) {
        EachGen eachGen = new EachGen();
        eachGen.setContainer(s2);
        eachGen.setCsvFile(new File(codeGenConfig.getInputFile()));
        eachGen.setDestinationDir(new File(directory.getDestination()));
        eachGen.setOutputCode(outputCode);
        eachGen.generate();
    }

    private static class DataSourceImpl
    implements DataSource {
        private String url;
        private String user;
        private String password;
        private String className;
        private File classPath;

        public DataSourceImpl(String className, String url, String user, String password, File driverClassPath) {
            this.className = className;
            this.url = url;
            this.user = user;
            this.password = password;
            this.classPath = driverClassPath;
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(this.user, this.password);
        }

        public Connection getConnection(String username, String password) throws SQLException {
            Properties info = new Properties();
            info.setProperty("user", username);
            info.setProperty("password", password);
            return this.getDriver(this.className, this.classPath).connect(this.url, info);
        }

        protected Driver getDriver(String className2, File classPath2) {
            Class<?> clazz = null;
            try {
                URL[] urls = new URL[]{classPath2.toURL()};
                URLClassLoader loader = new URLClassLoader(urls);
                clazz = loader.loadClass(className2);
                return (Driver)clazz.newInstance();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new InstantiationRuntimeException(clazz, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessRuntimeException(clazz, e);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundRuntimeException(e);
            }
        }

        public PrintWriter getLogWriter() throws SQLException {
            return new PrintWriter(System.out);
        }

        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        public void setLoginTimeout(int seconds) throws SQLException {
        }
    }

    static class DatabaseConfig {
        private String schemeName;
        private String[] tableNames;
        private String ignoreTablePattern;
        private DataSource dataSource;

        public DatabaseConfig(String schemeName, String[] tableNames, String ignoreTablePattern, DataSource dataSource) {
            this.schemeName = schemeName;
            this.tableNames = tableNames == null ? new String[0] : tableNames;
            this.ignoreTablePattern = ignoreTablePattern;
            this.dataSource = dataSource;
        }

        public String getSchemeName() {
            return this.schemeName;
        }

        public String[] getTableNames() {
            return this.tableNames;
        }

        public String getIgnoreTablePattern() {
            return this.ignoreTablePattern;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public boolean isUse() {
            return this.dataSource != null;
        }
    }

    static class ClassConfig {
        private String importCodeDataClass;
        private String dbClass;
        private String fkNameConverterClass;
        private String nameConverterClass;

        public String getImportCodeDataClass() {
            return this.importCodeDataClass;
        }

        public String getDbClass() {
            return this.dbClass;
        }

        public String getFkNameConverterClass() {
            return this.fkNameConverterClass;
        }

        public String getNameConverterClass() {
            return this.nameConverterClass;
        }

        public ClassConfig(String importCodeDataClass, String dbClass, String fkNameConverterClass, String nameConverterClass) {
            this.importCodeDataClass = importCodeDataClass;
            this.dbClass = dbClass;
            this.fkNameConverterClass = fkNameConverterClass;
            this.nameConverterClass = nameConverterClass;
        }
    }
}

