/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import junit.framework.TestCase;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.jdbc.dialect.Db2Dialect;

public class Db2DialectTest
extends TestCase {
    public void testExpressionFunctions_prefix() throws Exception {
        Db2Dialect dialect = new Db2Dialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Db2DialectTest.assertEquals((String)"a$$a$%a$_a$\uff05a$\uff3f%", (String)functions.prefix("a$a%a_a\uff05a\uff3f"));
    }

    public void testExpressionFunctions_prefix_escape() throws Exception {
        Db2Dialect dialect = new Db2Dialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Db2DialectTest.assertEquals((String)"a!!a!%a!_a!\uff05a!\uff3f%", (String)functions.prefix("a!a%a_a\uff05a\uff3f", '!'));
    }

    public void testExpressionFunctions_prefix_escapeWithDefault() throws Exception {
        Db2Dialect dialect = new Db2Dialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        Db2DialectTest.assertEquals((String)"a\\\\a\\%a\\_a\\\uff05a\\\uff3f%", (String)functions.prefix("a\\a%a_a\uff05a\uff3f", '\\'));
    }
}

