/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoBatchInsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchInsertQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setName("bbb");
        AutoBatchInsertQuery query = new AutoBatchInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setEntities(Arrays.asList(emp1, emp2));
        query.prepare();
        AutoBatchInsertQuery batchInsertQuery = query;
        AutoBatchInsertQueryTest.assertTrue((boolean)batchInsertQuery.isBatchSupported());
        AutoBatchInsertQueryTest.assertEquals((int)2, (int)batchInsertQuery.getSqls().size());
    }

    public void testOption_default() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(new Integer(10));
        AutoBatchInsertQuery query = new AutoBatchInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setEntities(Arrays.asList(emp1, emp2));
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchInsertQueryTest.assertEquals((String)"insert into EMP (ID, NAME, SALARY, VERSION) values (?, ?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchInsertQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchInsertQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchInsertQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchInsertQueryTest.assertEquals((Object)new Integer(1), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchInsertQueryTest.assertEquals((String)"insert into EMP (ID, NAME, SALARY, VERSION) values (?, ?, ?, ?)", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchInsertQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoBatchInsertQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchInsertQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoBatchInsertQueryTest.assertEquals((Object)new BigDecimal(2000), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoBatchInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }
}

