/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.dao;

import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.BatchSqlValidator;
import org.seasar.doma.internal.apt.dao.BatchSqlValidationDao;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;
import org.seasar.doma.message.Message;

public class BatchSqlValidatorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addSourcePath(new String[]{"src/main/java"});
        this.addSourcePath(new String[]{"src/test/java"});
    }

    public void testEmbeddedVariable() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testEmbeddedVariable", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp /*# orderBy */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        this.assertMessage(Message.DOMA4181);
    }

    public void testEmbeddedVariableSuppressed() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testEmbeddedVariableSuppressed", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp /*# orderBy */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        this.assertNoMessage();
    }

    public void testIf() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testIf", new Class[0]);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where /*%if true*/ id = 1 /*%end */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        this.assertMessage(Message.DOMA4182);
    }

    public void testIfSuppressed() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testIfSuppressed", new Class[0]);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where /*%if true*/ id = 1 /*%end */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        this.assertNoMessage();
    }

    public void testIfAndEmbeddedVariable() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testIfAndEmbeddedVariable", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where /*%if true*/ id = 1 /*%end */ /*# orderBy */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        BatchSqlValidatorTest.assertEquals((int)2, (int)this.getDiagnostics().size());
    }

    public void testIfAndEmbeddedVariableSuppressed() throws Exception {
        Class<BatchSqlValidationDao> target = BatchSqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testIfAndEmbeddedVariableSuppressed", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        BatchSqlValidator validator = new BatchSqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where /*%if true*/ id = 1 /*%end */ /*# orderBy */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
        this.assertNoMessage();
    }
}

