/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.Select;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class SelectMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue iterate;
    protected AnnotationValue ensureResult;
    protected AnnotationValue ensureResultMapping;
    protected AnnotationValue queryTimeout;
    protected AnnotationValue fetchSize;
    protected AnnotationValue maxRows;
    protected AnnotationValue mapKeyNaming;

    protected SelectMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationValue getIterate() {
        return this.iterate;
    }

    public AnnotationValue getEnsureResult() {
        return this.ensureResult;
    }

    public AnnotationValue getEnsureResultMapping() {
        return this.ensureResultMapping;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getFetchSize() {
        return this.fetchSize;
    }

    public AnnotationValue getMaxRows() {
        return this.maxRows;
    }

    public AnnotationValue getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException("queryTimeout");
        }
        return value;
    }

    public int getFetchSizeValue() {
        Integer value = AnnotationValueUtil.toInteger(this.fetchSize);
        if (value == null) {
            throw new AptIllegalStateException("fetchSize");
        }
        return value;
    }

    public int getMaxRowsValue() {
        Integer value = AnnotationValueUtil.toInteger(this.maxRows);
        if (value == null) {
            throw new AptIllegalStateException("maxRows");
        }
        return value;
    }

    public boolean getIterateValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.iterate);
        if (value == null) {
            throw new AptIllegalStateException("iterate");
        }
        return value;
    }

    public boolean getEnsureResultValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResult);
        if (value == null) {
            throw new AptIllegalStateException("ensureResult");
        }
        return value;
    }

    public boolean getEnsureResultMappingValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResultMapping);
        if (value == null) {
            throw new AptIllegalStateException("ensureResultMapping");
        }
        return value;
    }

    public MapKeyNamingType getMapKeyNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.mapKeyNaming);
        if (enumConstant == null) {
            throw new AptIllegalStateException("mapKeyNaming");
        }
        return MapKeyNamingType.valueOf(enumConstant.getSimpleName().toString());
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public static SelectMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(method, Select.class, env);
        if (annotationMirror == null) {
            return null;
        }
        SelectMirror result = new SelectMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("iterate".equals(name)) {
                result.iterate = value;
                continue;
            }
            if ("ensureResult".equals(name)) {
                result.ensureResult = value;
                continue;
            }
            if ("ensureResultMapping".equals(name)) {
                result.ensureResultMapping = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("fetchSize".equals(name)) {
                result.fetchSize = value;
                continue;
            }
            if ("maxRows".equals(name)) {
                result.maxRows = value;
                continue;
            }
            if (!"mapKeyNaming".equals(name)) continue;
            result.mapKeyNaming = value;
        }
        return result;
    }
}

