/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConnection;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.LocalTransactionalConnection;

public class LocalTransactionContextTest
extends TestCase {
    public void testReleaseAndGetSavepoint() throws Exception {
        LocalTransactionalConnection connection = new LocalTransactionalConnection((Connection)new MockConnection());
        LocalTransactionContext context = new LocalTransactionContext(connection);
        context.addSavepoint("1", (Savepoint)new MySavepoint("1"));
        context.addSavepoint("2", (Savepoint)new MySavepoint("2"));
        context.addSavepoint("3", (Savepoint)new MySavepoint("3"));
        context.addSavepoint("4", (Savepoint)new MySavepoint("4"));
        context.addSavepoint("5", (Savepoint)new MySavepoint("5"));
        Savepoint savepoint = context.releaseAndGetSavepoint("3");
        LocalTransactionContextTest.assertEquals((String)"3", (String)savepoint.getSavepointName());
        LocalTransactionContextTest.assertNull((Object)context.getSavepoint("1"));
        LocalTransactionContextTest.assertNull((Object)context.getSavepoint("2"));
        LocalTransactionContextTest.assertNull((Object)context.getSavepoint("3"));
        LocalTransactionContextTest.assertNotNull((Object)context.getSavepoint("4"));
        LocalTransactionContextTest.assertNotNull((Object)context.getSavepoint("5"));
    }

    class MySavepoint
    implements Savepoint {
        String name;

        public MySavepoint(String name) {
            this.name = name;
        }

        @Override
        public int getSavepointId() throws SQLException {
            return 0;
        }

        @Override
        public String getSavepointName() throws SQLException {
            return this.name;
        }
    }
}

