/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Entity;
import org.seasar.doma.EntityField;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMetaFactory;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.EntityMirror;
import org.seasar.doma.internal.apt.mirror.TableMirror;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityListener;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.NullEntityListener;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityMetaFactory
implements TypeElementMetaFactory<EntityMeta> {
    protected final ProcessingEnvironment env;
    protected final EntityPropertyMetaFactory propertyMetaFactory;

    public EntityMetaFactory(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory) {
        AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
        this.env = env;
        this.propertyMetaFactory = propertyMetaFactory;
    }

    @Override
    public EntityMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        EntityMirror entityMirror = EntityMirror.newInstance(classElement, this.env);
        if (entityMirror == null) {
            throw new AptIllegalStateException("entityMirror.");
        }
        EntityMeta entityMeta = new EntityMeta(entityMirror, classElement);
        TypeMirror entityListener = this.resolveEntityListener(classElement);
        entityMeta.setEntityListener(entityListener);
        TypeElement entityListenerElement = TypeMirrorUtil.toTypeElement(entityListener, this.env);
        if (entityListenerElement == null) {
            throw new AptIllegalStateException("entityListener.");
        }
        entityMeta.setEntityListenerElement(entityListenerElement);
        entityMeta.setGenericEntityListener(!entityListenerElement.getTypeParameters().isEmpty());
        NamingType namingType = this.resolveNamingType(classElement);
        entityMeta.setNamingType(namingType);
        boolean immutable = this.resolveImmutable(classElement, entityMirror);
        entityMeta.setImmutable(immutable);
        entityMeta.setEntityName(classElement.getSimpleName().toString());
        entityMeta.setEntityTypeName(TypeMirrorUtil.getTypeName(classElement.asType(), this.env));
        this.doClassElement(classElement, entityMeta);
        this.doFieldElements(classElement, entityMeta);
        this.validateGeneratedId(classElement, entityMeta);
        this.doConstructor(classElement, entityMeta);
        return entityMeta;
    }

    protected TypeMirror resolveEntityListener(TypeElement classElement) {
        TypeMirror result = TypeMirrorUtil.getTypeMirror(NullEntityListener.class, this.env);
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "listener")) {
            if (value == null) continue;
            TypeMirror listenerType = AnnotationValueUtil.toType(value);
            if (listenerType == null) {
                throw new AptIllegalStateException("listener");
            }
            result = listenerType;
        }
        return result;
    }

    protected NamingType resolveNamingType(TypeElement classElement) {
        NamingType result = NamingType.NONE;
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "naming")) {
            if (value == null) continue;
            VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(value);
            if (enumConstant == null) {
                throw new AptIllegalStateException("naming");
            }
            result = NamingType.valueOf(enumConstant.getSimpleName().toString());
        }
        return result;
    }

    protected boolean resolveImmutable(TypeElement classElement, EntityMirror entityMirror) {
        boolean result = false;
        ArrayList<Boolean> resolvedList = new ArrayList<Boolean>();
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "immutable")) {
            if (value == null) continue;
            Boolean immutable = AnnotationValueUtil.toBoolean(value);
            if (immutable == null) {
                throw new AptIllegalStateException("immutable");
            }
            result = immutable;
            resolvedList.add(immutable);
        }
        if (resolvedList.contains(Boolean.TRUE) && resolvedList.contains(Boolean.FALSE)) {
            throw new AptException((MessageResource)Message.DOMA4226, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getImmutable(), new Object[0]);
        }
        return result;
    }

    protected List<AnnotationValue> getEntityElementValueList(TypeElement classElement, String entityElementName) {
        LinkedList<AnnotationValue> list = new LinkedList<AnnotationValue>();
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            AnnotationMirror annMirror = ElementUtil.getAnnotationMirror(t, Entity.class, this.env);
            if (annMirror != null) {
                AnnotationValue value = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annMirror.getElementValues().entrySet()) {
                    ExecutableElement element = entry.getKey();
                    if (!entityElementName.equals(element.getSimpleName().toString())) continue;
                    value = entry.getValue();
                    break;
                }
                list.add(value);
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
        Collections.reverse(list);
        return list;
    }

    protected void doClassElement(TypeElement classElement, EntityMeta entityMeta) {
        this.validateClass(classElement, entityMeta);
        this.validateEntityListener(classElement, entityMeta);
        this.doTable(classElement, entityMeta);
    }

    protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        if (classElement.getKind() != ElementKind.CLASS) {
            throw new AptException((MessageResource)Message.DOMA4015, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), new Object[0]);
        }
        if (classElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4018, this.env, (Element)classElement, new Object[0]);
        }
        if (!classElement.getTypeParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4051, this.env, (Element)classElement, new Object[0]);
        }
    }

    protected void validateEntityListener(TypeElement classElement, EntityMeta entityMeta) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        TypeMirror listenerType = entityMirror.getListenerValue();
        TypeElement listenerElement = TypeMirrorUtil.toTypeElement(listenerType, this.env);
        if (listenerElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (listenerElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4166, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerElement.getQualifiedName());
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(listenerElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4167, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerElement.getQualifiedName());
        }
        if (listenerElement.getTypeParameters().size() > 0) {
            this.validateGenericEntityListener(classElement, entityMeta, listenerElement);
        } else {
            this.validateNonGenericEntityListener(classElement, entityMeta, listenerType);
        }
        TypeElement inheritedListenerElement = entityMeta.getEntityListenerElement();
        if (!TypeMirrorUtil.isSameType(listenerType, inheritedListenerElement.asType(), this.env)) {
            this.validateInheritedEntityListener(classElement, entityMeta, inheritedListenerElement);
        }
    }

    protected void validateGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement listenerElement) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        List<? extends TypeParameterElement> typeParams = listenerElement.getTypeParameters();
        if (typeParams.size() == 0) {
            throw new AptIllegalStateException("typeParams size should be more than 0");
        }
        if (typeParams.size() > 1) {
            throw new AptException((MessageResource)Message.DOMA4227, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[0]);
        }
        TypeParameterElement typeParam = typeParams.get(0);
        for (TypeMirror typeMirror : typeParam.getBounds()) {
            if (TypeMirrorUtil.isAssignable(classElement.asType(), typeMirror, this.env)) continue;
            throw new AptException((MessageResource)Message.DOMA4229, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName());
        }
        if (this.findListenerTypeParam(listenerElement, 0) == null) {
            throw new AptException((MessageResource)Message.DOMA4228, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), typeParam.getSimpleName());
        }
    }

    protected TypeParameterElement findListenerTypeParam(TypeElement listenerElement, int typeParamIndex) {
        TypeParameterElement typeParam = listenerElement.getTypeParameters().get(typeParamIndex);
        for (TypeMirror typeMirror : listenerElement.getInterfaces()) {
            DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror, this.env);
            if (declaredType == null) continue;
            int i = -1;
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                ++i;
                TypeVariable typeVariable = TypeMirrorUtil.toTypeVariable(typeMirror2, this.env);
                if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
                if (TypeMirrorUtil.isSameType((TypeMirror)declaredType, EntityListener.class, this.env)) {
                    return typeParam;
                }
                TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
                if (typeElement == null) {
                    throw new AptIllegalStateException(declaredType.toString());
                }
                TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
                if (candidate == null) continue;
                return candidate;
            }
        }
        TypeMirror superclass = listenerElement.getSuperclass();
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(superclass, this.env);
        if (declaredType == null) {
            return null;
        }
        int i = -1;
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            ++i;
            TypeVariable typeVariable = TypeMirrorUtil.toTypeVariable(typeMirror, this.env);
            if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
            if (TypeMirrorUtil.isSameType((TypeMirror)declaredType, EntityListener.class, this.env)) {
                return typeParam;
            }
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
            if (typeElement == null) {
                throw new AptIllegalStateException(declaredType.toString());
            }
            TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    protected void validateNonGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeMirror listenerType) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        TypeMirror argumentType = this.getListenerArgumentType(listenerType);
        if (argumentType == null) {
            throw new AptException((MessageResource)Message.DOMA4202, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[0]);
        }
        if (!TypeMirrorUtil.isAssignable(classElement.asType(), argumentType, this.env)) {
            throw new AptException((MessageResource)Message.DOMA4038, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerType, argumentType, classElement.getQualifiedName());
        }
    }

    protected void validateInheritedEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement inheritedListenerElement) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        List<? extends TypeParameterElement> typeParams = inheritedListenerElement.getTypeParameters();
        if (typeParams.size() == 0) {
            throw new AptException((MessageResource)Message.DOMA4230, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), inheritedListenerElement.getQualifiedName(), classElement.getQualifiedName());
        }
        TypeParameterElement typeParam = typeParams.get(0);
        for (TypeMirror typeMirror : typeParam.getBounds()) {
            if (TypeMirrorUtil.isAssignable(classElement.asType(), typeMirror, this.env)) continue;
            throw new AptException((MessageResource)Message.DOMA4231, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), inheritedListenerElement.getQualifiedName(), typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName());
        }
    }

    protected TypeMirror getListenerArgumentType(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.env.getTypeUtils().directSupertypes(typeMirror)) {
            if (!TypeMirrorUtil.isAssignable(typeMirror2, EntityListener.class, this.env)) continue;
            if (TypeMirrorUtil.isSameType(typeMirror2, EntityListener.class, this.env)) {
                DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror2, this.env);
                if (declaredType == null) {
                    throw new AptIllegalStateException("declaredType");
                }
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                if (args.size() != 1) {
                    return null;
                }
                return args.get(0);
            }
            TypeMirror argumentType = this.getListenerArgumentType(typeMirror2);
            if (argumentType == null) continue;
            return argumentType;
        }
        return null;
    }

    protected void doTable(TypeElement classElement, EntityMeta entityMeta) {
        TableMirror tableMirror = TableMirror.newInstance(classElement, this.env);
        if (tableMirror == null) {
            return;
        }
        entityMeta.setTableMirror(tableMirror);
    }

    protected void doFieldElements(TypeElement classElement, EntityMeta entityMeta) {
        for (VariableElement fieldElement : this.getFieldElements(classElement)) {
            try {
                if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                    this.doOriginalStatesField(classElement, fieldElement, entityMeta);
                    continue;
                }
                this.doEntityPropertyMeta(fieldElement, entityMeta);
                if (!entityMeta.isImmutable() || fieldElement.getModifiers().contains((Object)Modifier.FINAL)) continue;
                throw new AptException((MessageResource)Message.DOMA4225, this.env, (Element)fieldElement, new Object[0]);
            }
            catch (AptException e) {
                Notifier.notify(this.env, e);
                entityMeta.setError(true);
            }
        }
    }

    protected List<VariableElement> getFieldElements(TypeElement classElement) {
        LinkedList<VariableElement> results = new LinkedList<VariableElement>();
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            if (t.getAnnotation(Entity.class) != null) {
                LinkedList<VariableElement> fields = new LinkedList<VariableElement>();
                for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                    fields.add(field);
                }
                Collections.reverse(fields);
                results.addAll(fields);
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
        Collections.reverse(results);
        LinkedList hiderFields = new LinkedList(results);
        Iterator it = results.iterator();
        while (it.hasNext()) {
            VariableElement hidden = (VariableElement)it.next();
            for (VariableElement hider : hiderFields) {
                if (!this.env.getElementUtils().hides(hider, hidden)) continue;
                it.remove();
            }
        }
        return results;
    }

    protected void doOriginalStatesField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        if (entityMeta.hasOriginalStatesMeta()) {
            throw new AptException((MessageResource)Message.DOMA4125, this.env, (Element)fieldElement, new Object[0]);
        }
        if (classElement.equals(fieldElement.getEnclosingElement()) && !TypeMirrorUtil.isSameType(fieldElement.asType(), classElement.asType(), this.env)) {
            throw new AptException((MessageResource)Message.DOMA4135, this.env, (Element)fieldElement, classElement.getQualifiedName());
        }
        TypeElement enclosingElement = ElementUtil.toTypeElement(fieldElement.getEnclosingElement(), this.env);
        if (enclosingElement == null) {
            throw new AptIllegalStateException(fieldElement.toString());
        }
        if (entityMeta.isImmutable() && classElement.equals(enclosingElement)) {
            throw new AptException((MessageResource)Message.DOMA4224, this.env, (Element)fieldElement, new Object[0]);
        }
        OriginalStatesMeta originalStatesMeta = new OriginalStatesMeta(classElement, fieldElement, enclosingElement, this.env);
        entityMeta.setOriginalStatesMeta(originalStatesMeta);
    }

    protected void doEntityPropertyMeta(VariableElement fieldElement, EntityMeta entityMeta) {
        this.validateFieldAnnotation(fieldElement, entityMeta);
        EntityPropertyMeta propertyMeta = this.propertyMetaFactory.createEntityPropertyMeta(fieldElement, entityMeta);
        entityMeta.addPropertyMeta(propertyMeta);
    }

    protected void validateFieldAnnotation(VariableElement fieldElement, EntityMeta entityMeta) {
        TypeElement foundAnnotationTypeElement = null;
        for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
            if (typeElement.getAnnotation(EntityField.class) == null) continue;
            if (foundAnnotationTypeElement != null) {
                throw new AptException((MessageResource)Message.DOMA4086, this.env, (Element)fieldElement, foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName());
            }
            foundAnnotationTypeElement = typeElement;
        }
    }

    protected void validateGeneratedId(TypeElement classElement, EntityMeta entityMeta) {
        if (entityMeta.hasGeneratedIdPropertyMeta() && entityMeta.getIdPropertyMetas().size() > 1) {
            throw new AptException((MessageResource)Message.DOMA4036, this.env, (Element)classElement, new Object[0]);
        }
    }

    protected void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
        if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (entityMeta.isImmutable()) {
            ExecutableElement constructor = this.getSuitableConstructor(classElement, entityMeta);
            if (constructor == null || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new AptException((MessageResource)Message.DOMA4221, this.env, (Element)classElement, new Object[0]);
            }
            entityMeta.setConstructor(constructor);
        } else {
            ExecutableElement constructor = ElementUtil.getNoArgConstructor(classElement, this.env);
            if (constructor == null || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new AptException((MessageResource)Message.DOMA4124, this.env, (Element)classElement, new Object[0]);
            }
        }
    }

    protected ExecutableElement getSuitableConstructor(TypeElement classElement, EntityMeta entityMeta) {
        HashMap<String, TypeMirror> types = new HashMap<String, TypeMirror>();
        for (EntityPropertyMeta propertyMeta : entityMeta.getAllPropertyMetas()) {
            types.put(propertyMeta.getName(), propertyMeta.getType());
        }
        block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
            int validCount = 0;
            for (VariableElement variableElement : constructor.getParameters()) {
                String name = variableElement.getSimpleName().toString();
                TypeMirror paramType = variableElement.asType();
                TypeMirror propertyType = (TypeMirror)types.get(name);
                if (propertyType == null || !TypeMirrorUtil.isSameType(paramType, propertyType, this.env)) continue block1;
                ++validCount;
            }
            if (types.size() != validCount) continue;
            return constructor;
        }
        return null;
    }
}

