/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Date;
import javax.annotation.processing.ProcessingEnvironment;
import org.seasar.doma.internal.Artifact;

public final class Options {
    public static final String TEST = "test";
    public static final String DEBUG = "debug";
    public static final String DAO_PACKAGE = "dao.package";
    public static final String DAO_SUBPACKAGE = "dao.subpackage";
    public static final String DAO_SUFFIX = "dao.suffix";
    public static final String ENTITY_FIELD_PREFIX = "entity.field.prefix";
    public static final String EXPR_FUNCTIONS = "expr.functions";
    public static final String DOMAIN_CONVERTERS = "domain.converters";
    public static final String SQL_VALIDATION = "sql.validation";
    public static final String VERSION_VALIDATION = "version.validation";

    public static boolean isTestEnabled(ProcessingEnvironment env) {
        String test = env.getOptions().get(TEST);
        return Boolean.valueOf(test);
    }

    public static String getVersion(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return "@VERSION@";
        }
        return Artifact.getVersion();
    }

    public static Date getDate(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return new Date(0L);
        }
        return new Date();
    }

    public static boolean isDebugEnabled(ProcessingEnvironment env) {
        String debug = env.getOptions().get(DEBUG);
        return Boolean.valueOf(debug);
    }

    public static String getDaoPackage(ProcessingEnvironment env) {
        String pkg = env.getOptions().get(DAO_PACKAGE);
        return pkg != null ? pkg : null;
    }

    public static String getDaoSubpackage(ProcessingEnvironment env) {
        String subpackage = env.getOptions().get(DAO_SUBPACKAGE);
        return subpackage != null ? subpackage : null;
    }

    public static String getDaoSuffix(ProcessingEnvironment env) {
        String suffix = env.getOptions().get(DAO_SUFFIX);
        return suffix != null ? suffix : "Impl";
    }

    public static String getEntityFieldPrefix(ProcessingEnvironment env) {
        String prefix = env.getOptions().get(ENTITY_FIELD_PREFIX);
        if ("none".equalsIgnoreCase(prefix)) {
            return "";
        }
        return prefix != null ? prefix : "$";
    }

    public static String getExprFunctions(ProcessingEnvironment env) {
        String name = env.getOptions().get(EXPR_FUNCTIONS);
        return name != null ? name : null;
    }

    public static String getDomainConverters(ProcessingEnvironment env) {
        String converters = env.getOptions().get(DOMAIN_CONVERTERS);
        return converters != null ? converters : null;
    }

    public static boolean getSqlValidation(ProcessingEnvironment env) {
        String v = env.getOptions().get(SQL_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    public static boolean getVersionValidation(ProcessingEnvironment env) {
        String v = env.getOptions().get(VERSION_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    protected static class Constants {
        public static final String DEFAULT_DAO_SUFFIX = "Impl";
        public static final String DEFAULT_ENTITY_FIELD_PREFIX = "$";

        protected Constants() {
        }
    }
}

