/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.mock.MockConnection;
import org.seasar.doma.internal.jdbc.mock.MockDataSource;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.UtilLoggingJdbcLogger;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionAlreadyBegunException;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.LocalTransactionNotYetBegunException;
import org.seasar.doma.jdbc.tx.SavepointAleadyExistsException;
import org.seasar.doma.jdbc.tx.SavepointNotFoundException;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;

public class LocalTransactionTest
extends TestCase {
    private final MockConnection connection = new MockConnection();
    private final MockDataSource dataSource = new MockDataSource(this.connection);
    private final ThreadLocal<LocalTransactionContext> connectionHolder = new ThreadLocal();
    private final UtilLoggingJdbcLogger jdbcLogger = new UtilLoggingJdbcLogger();
    private final LocalTransaction transaction = new LocalTransaction((DataSource)this.dataSource, this.connectionHolder, (JdbcLogger)this.jdbcLogger);

    public void testBegin() throws Exception {
        this.transaction.begin();
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertEquals((int)TransactionIsolationLevel.READ_COMMITTED.getLevel(), (int)this.connection.isolationLevel);
    }

    public void testBeginImlicitDefaultTransactionIsolationLevel() throws Exception {
        LocalTransaction transaction = new LocalTransaction((DataSource)this.dataSource, this.connectionHolder, (JdbcLogger)this.jdbcLogger, TransactionIsolationLevel.SERIALIZABLE);
        transaction.begin();
        LocalTransactionTest.assertTrue((boolean)transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertEquals((int)TransactionIsolationLevel.SERIALIZABLE.getLevel(), (int)this.connection.isolationLevel);
    }

    public void testBeginWithTransactionIsolationLevel() throws Exception {
        this.transaction.begin(TransactionIsolationLevel.SERIALIZABLE);
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertEquals((int)TransactionIsolationLevel.SERIALIZABLE.getLevel(), (int)this.connection.isolationLevel);
    }

    public void testBegin_alreadyBegun() throws Exception {
        this.transaction.begin();
        try {
            this.transaction.begin();
            LocalTransactionTest.fail();
        }
        catch (LocalTransactionAlreadyBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testBegin_failedToBegin() throws Exception {
        final SQLException exception = new SQLException();
        MockConnection connection = new MockConnection(){

            @Override
            public void setAutoCommit(boolean autoCommit) throws SQLException {
                throw exception;
            }
        };
        MockDataSource dataSource = new MockDataSource(connection);
        ThreadLocal connectionHolder = new ThreadLocal();
        UtilLoggingJdbcLogger jdbcLogger = new UtilLoggingJdbcLogger(){

            public void logLocalTransactionBegun(String callerClassName, String callerMethodName, String transactionId) {
                Assert.fail();
            }
        };
        LocalTransaction transaction = new LocalTransaction((DataSource)dataSource, connectionHolder, (JdbcLogger)jdbcLogger);
        try {
            transaction.begin();
            LocalTransactionTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            LocalTransactionTest.assertEquals((Object)exception, (Object)expected.getCause());
        }
    }

    public void testBegin_failedToSetTransactionIsolation() throws Exception {
        final SQLException exception = new SQLException();
        MockConnection connection = new MockConnection(){

            @Override
            public void setTransactionIsolation(int level) throws SQLException {
                throw exception;
            }
        };
        MockDataSource dataSource = new MockDataSource(connection);
        ThreadLocal connectionHolder = new ThreadLocal();
        UtilLoggingJdbcLogger jdbcLogger = new UtilLoggingJdbcLogger(){

            public void logLocalTransactionBegun(String callerClassName, String callerMethodName, String transactionId) {
                Assert.fail();
            }
        };
        LocalTransaction transaction = new LocalTransaction((DataSource)dataSource, connectionHolder, (JdbcLogger)jdbcLogger);
        try {
            transaction.begin(TransactionIsolationLevel.READ_COMMITTED);
            LocalTransactionTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            LocalTransactionTest.assertEquals((Object)exception, (Object)expected.getCause());
        }
    }

    public void testSetSavepoint() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertTrue((boolean)this.connection.savepointNames.contains("hoge"));
    }

    public void testSetSavepoint_alreadyExists() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        try {
            this.transaction.setSavepoint("hoge");
            LocalTransactionTest.fail();
        }
        catch (SavepointAleadyExistsException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testSetSavepoint_notYetBegun() throws Exception {
        try {
            this.transaction.setSavepoint("hoge");
            LocalTransactionTest.fail();
        }
        catch (LocalTransactionNotYetBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testSetSavepoint_nullPointer() throws Exception {
        this.transaction.begin();
        try {
            this.transaction.setSavepoint(null);
            LocalTransactionTest.fail();
        }
        catch (DomaNullPointerException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testHasSavepoint() throws Exception {
        this.transaction.begin();
        LocalTransactionTest.assertFalse((boolean)this.transaction.hasSavepoint("hoge"));
        this.transaction.setSavepoint("hoge");
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertTrue((boolean)this.transaction.hasSavepoint("hoge"));
    }

    public void testHasSavepoint_notYetBegun() throws Exception {
        try {
            this.transaction.hasSavepoint("hoge");
            LocalTransactionTest.fail();
        }
        catch (LocalTransactionNotYetBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testHasSavepoint_nullPointer() throws Exception {
        this.transaction.begin();
        try {
            this.transaction.hasSavepoint(null);
            LocalTransactionTest.fail();
        }
        catch (DomaNullPointerException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testReleaseSavepoint() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        this.transaction.setSavepoint("foo");
        this.transaction.setSavepoint("bar");
        this.transaction.releaseSavepoint("foo");
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertFalse((boolean)this.connection.savepointNames.contains("hoge"));
        LocalTransactionTest.assertFalse((boolean)this.connection.savepointNames.contains("foo"));
        LocalTransactionTest.assertTrue((boolean)this.connection.savepointNames.contains("bar"));
    }

    public void testReleaseSavepoint_notYetBegun() throws Exception {
        try {
            this.transaction.releaseSavepoint("hoge");
            LocalTransactionTest.fail();
        }
        catch (LocalTransactionNotYetBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testReleaseSavepoint_notFound() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        try {
            this.transaction.releaseSavepoint("foo");
            LocalTransactionTest.fail();
        }
        catch (SavepointNotFoundException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testReleaseSavepoint_nullPointer() throws Exception {
        this.transaction.begin();
        try {
            this.transaction.releaseSavepoint(null);
            LocalTransactionTest.fail();
        }
        catch (DomaNullPointerException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testCommit() {
        this.transaction.begin();
        this.transaction.commit();
        LocalTransactionTest.assertFalse((boolean)this.transaction.isActive());
        LocalTransactionTest.assertTrue((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertTrue((boolean)this.connection.committed);
    }

    public void testCommit_notYetBegun() throws Exception {
        try {
            this.transaction.commit();
            LocalTransactionTest.fail();
        }
        catch (LocalTransactionNotYetBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testRollback() {
        this.transaction.begin();
        this.transaction.rollback();
        LocalTransactionTest.assertFalse((boolean)this.transaction.isActive());
        LocalTransactionTest.assertTrue((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertTrue((boolean)this.connection.rolledback);
    }

    public void testRollback_notYetBegun() throws Exception {
        this.transaction.rollback();
    }

    public void testRollbackSavepoint() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        this.transaction.rollback("hoge");
        LocalTransactionTest.assertTrue((boolean)this.transaction.isActive());
        LocalTransactionTest.assertFalse((boolean)this.connection.autoCommit);
        LocalTransactionTest.assertFalse((boolean)this.connection.savepointNames.contains("hoge"));
    }

    public void testRollbackSavepoint_notYetBegun() throws Exception {
        try {
            this.transaction.rollback("hoge");
        }
        catch (LocalTransactionNotYetBegunException expected) {
            System.out.println(expected.getMessage());
        }
    }

    public void testRollbackSavepoint_notFound() throws Exception {
        this.transaction.begin();
        this.transaction.setSavepoint("hoge");
        try {
            this.transaction.rollback("foo");
            LocalTransactionTest.fail();
        }
        catch (SavepointNotFoundException expected) {
            System.out.println(expected.getMessage());
        }
    }
}

