/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.message.Message;

public class UtilLoggingJdbcLogger
implements JdbcLogger {
    protected final Level level;
    protected final Logger logger;

    public UtilLoggingJdbcLogger() {
        this(Level.INFO);
    }

    public UtilLoggingJdbcLogger(Level level) {
        if (level == null) {
            throw new DomaNullPointerException("level");
        }
        this.level = level;
        this.logger = Logger.getLogger(UtilLoggingJdbcLogger.class.getName());
    }

    @Override
    public void logDaoMethodEntering(String callerClassName, String callerMethodName, Object ... args) {
        this.logger.logp(this.level, callerClassName, callerMethodName, "ENTRY");
    }

    @Override
    public void logDaoMethodExiting(String callerClassName, String callerMethodName, Object result) {
        this.logger.logp(this.level, callerClassName, callerMethodName, "RETURN {0}", result);
    }

    @Override
    public void logDaoMethodThrowing(String callerClassName, String callerMethodName, RuntimeException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, "THROW {0}", e.toString());
    }

    @Override
    public void logSqlExecutionSkipping(String callerClassName, String callerMethodName, SqlExecutionSkipCause cause) {
        this.logger.logp(this.level, callerClassName, callerMethodName, cause.name());
    }

    @Override
    public void logSql(String callerClassName, String callerMethodName, Sql<?> sql) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2076.getMessage(sql.getSqlFilePath(), sql.getFormattedSql()));
    }

    @Override
    public void logLocalTransactionBegun(String callerClassName, String callerMethodName, String transactionId) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2063.getMessage(transactionId));
    }

    @Override
    public void logLocalTransactionEnded(String callerClassName, String callerMethodName, String transactionId) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2064.getMessage(transactionId));
    }

    @Override
    public void logLocalTransactionSavepointCreated(String callerClassName, String callerMethodName, String transactionId, String savepointName) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2065.getMessage(transactionId, savepointName));
    }

    @Override
    public void logLocalTransactionSavepointReleased(String callerClassName, String callerMethodName, String transactionId, String savepointName) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2066.getMessage(transactionId, savepointName));
    }

    @Override
    public void logLocalTransactionCommitted(String callerClassName, String callerMethodName, String transactionId) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2067.getMessage(transactionId));
    }

    @Override
    public void logLocalTransactionRolledback(String callerClassName, String callerMethodName, String transactionId) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2068.getMessage(transactionId));
    }

    @Override
    public void logLocalTransactionSavepointRolledback(String callerClassName, String callerMethodName, String transactionId, String savepointName) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2069.getMessage(transactionId, savepointName));
    }

    @Override
    public void logLocalTransactionRollbackFailure(String callerClassName, String callerMethodName, String transactionId, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2070.getMessage(transactionId));
    }

    @Override
    public void logAutoCommitEnablingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2071.getMessage(new Object[0]), e);
    }

    @Override
    public void logTransactionIsolationSettingFailuer(String callerClassName, String callerMethodName, int transactionIsolationLevel, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2072.getMessage(transactionIsolationLevel), e);
    }

    @Override
    public void logConnectionClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2073.getMessage(new Object[0]), e);
    }

    @Override
    public void logStatementClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2074.getMessage(new Object[0]), e);
    }

    @Override
    public void logResultSetClosingFailure(String callerClassName, String callerMethodName, SQLException e) {
        this.logger.logp(this.level, callerClassName, callerMethodName, Message.DOMA2075.getMessage(new Object[0]), e);
    }
}

