/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.TypeKindVisitor6;
import org.seasar.doma.Domain;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyNameCollector;
import org.seasar.doma.internal.apt.meta.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractQueryMetaFactory<M extends AbstractQueryMeta>
implements QueryMetaFactory {
    protected final ProcessingEnvironment env;

    protected AbstractQueryMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    protected void doTypeParameters(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            String name = TypeMirrorUtil.getTypeParameterName(typeParameterElement.asType(), this.env);
            ((AbstractQueryMeta)queryMeta).addTypeParameterName(name);
        }
    }

    protected abstract void doReturnType(M var1, ExecutableElement var2, DaoMeta var3);

    protected abstract void doParameters(M var1, ExecutableElement var2, DaoMeta var3);

    protected void doThrowTypes(M queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            ((AbstractQueryMeta)queryMeta).addThrownTypeName(TypeMirrorUtil.getTypeName(typeMirror, this.env));
        }
    }

    protected boolean isPrimitiveInt(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.INT;
    }

    protected boolean isPrimitiveIntArray(TypeMirror typeMirror) {
        return typeMirror.accept(new TypeKindVisitor6<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return t.getComponentType().getKind() == TypeKind.INT;
            }
        }, null);
    }

    protected boolean isPrimitiveVoid(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.VOID;
    }

    protected boolean isEntity(TypeMirror typeMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(typeMirror, this.env);
        return typeElement != null && typeElement.getAnnotation(Entity.class) != null;
    }

    protected boolean isDomain(TypeMirror typeMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(typeMirror, this.env);
        return typeElement != null && typeElement.getAnnotation(Domain.class) != null;
    }

    protected boolean isConfig(TypeMirror typeMirror) {
        return TypeMirrorUtil.isSameType(typeMirror, Config.class, this.env);
    }

    protected boolean isCollection(TypeMirror typeMirror) {
        return TypeMirrorUtil.isAssignable(typeMirror, Collection.class, this.env);
    }

    protected boolean isSelectOptions(TypeMirror typeMirror) {
        return TypeMirrorUtil.isAssignable(typeMirror, SelectOptions.class, this.env);
    }

    protected boolean isIterationCallback(TypeMirror typeMirror) {
        return TypeMirrorUtil.isAssignable(typeMirror, IterationCallback.class, this.env);
    }

    protected void validateEntityPropertyNames(TypeMirror entityType, ExecutableElement method, AnnotationMirror annotationMirror, AnnotationValue includeValue, AnnotationValue excludeValue) {
        List<String> includedPropertyNames = AnnotationValueUtil.toStringList(includeValue);
        List<String> excludedPropertyNames = AnnotationValueUtil.toStringList(excludeValue);
        if (includedPropertyNames != null && !includedPropertyNames.isEmpty() || excludedPropertyNames != null && !excludedPropertyNames.isEmpty()) {
            EntityPropertyNameCollector collector = new EntityPropertyNameCollector(this.env);
            Set<String> names = collector.collect(entityType);
            for (String included : includedPropertyNames) {
                if (names.contains(included)) continue;
                throw new AptException((MessageResource)Message.DOMA4084, this.env, (Element)method, annotationMirror, includeValue, included, entityType);
            }
            for (String excluded : excludedPropertyNames) {
                if (names.contains(excluded)) continue;
                throw new AptException((MessageResource)Message.DOMA4085, this.env, (Element)method, annotationMirror, excludeValue, excluded, entityType);
            }
        }
    }

    protected QueryReturnMeta createReturnMeta(ExecutableElement method) {
        return new QueryReturnMeta(method, this.env);
    }

    protected QueryParameterMeta createParameterMeta(VariableElement parameter) {
        QueryParameterMeta queryParameterMeta = new QueryParameterMeta(parameter, this.env);
        return queryParameterMeta;
    }
}

