/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;

public class ConstructorDeclaration {
    protected ExecutableElement element;
    protected List<TypeParameterDeclaration> typeParameterDeclarations;
    protected ProcessingEnvironment env;

    protected ConstructorDeclaration() {
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public TypeDeclaration getTypeDeclaration() {
        TypeMirror returnType = this.resolveTypeParameter(this.element.asType());
        return TypeDeclaration.newTypeDeclaration(returnType, this.env);
    }

    protected TypeMirror resolveTypeParameter(TypeMirror formalType) {
        for (TypeParameterDeclaration typeParameterDecl : this.typeParameterDeclarations) {
            if (!formalType.equals(typeParameterDecl.getFormalType())) continue;
            return typeParameterDecl.getActualType();
        }
        return formalType;
    }

    public static ConstructorDeclaration newInstance(ExecutableElement constructorElement, List<TypeParameterDeclaration> typeParameterDeclarations, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)constructorElement, typeParameterDeclarations, (Object)env);
        AssertionUtil.assertTrue(constructorElement.getKind() == ElementKind.CONSTRUCTOR, new Object[0]);
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
        constructorDeclaration.element = constructorElement;
        constructorDeclaration.typeParameterDeclarations = typeParameterDeclarations;
        constructorDeclaration.env = env;
        return constructorDeclaration;
    }
}

