/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.GroupByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.GroupByClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.HavingClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.HavingClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNodeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class SelectStatementNode
extends AbstractSqlNode {
    protected SelectClauseNode selectClauseNode;
    protected FromClauseNode fromClauseNode;
    protected WhereClauseNode whereClauseNode;
    protected GroupByClauseNode groupByClauseNode;
    protected HavingClauseNode havingClauseNode;
    protected OrderByClauseNode orderByClauseNode;
    protected ForUpdateClauseNode forUpdateClauseNode;

    public SelectClauseNode getSelectClauseNode() {
        return this.selectClauseNode;
    }

    public void setSelectClauseNode(SelectClauseNode selectClauseNode) {
        this.selectClauseNode = selectClauseNode;
        this.addNodeInternal(selectClauseNode);
    }

    public FromClauseNode getFromClauseNode() {
        return this.fromClauseNode;
    }

    public void setFromClauseNode(FromClauseNode fromClauseNode) {
        this.fromClauseNode = fromClauseNode;
        this.addNodeInternal(fromClauseNode);
    }

    public WhereClauseNode getWhereClauseNode() {
        return this.whereClauseNode;
    }

    public void setWhereClauseNode(WhereClauseNode whereClauseNode) {
        this.whereClauseNode = whereClauseNode;
        this.addNodeInternal(whereClauseNode);
    }

    public GroupByClauseNode getGroupByClauseNode() {
        return this.groupByClauseNode;
    }

    public void setGroupByClauseNode(GroupByClauseNode groupByClauseNode) {
        this.groupByClauseNode = groupByClauseNode;
        this.addNodeInternal(groupByClauseNode);
    }

    public HavingClauseNode getHavingClauseNode() {
        return this.havingClauseNode;
    }

    public void setHavingClauseNode(HavingClauseNode havingClauseNode) {
        this.havingClauseNode = havingClauseNode;
        this.addNodeInternal(havingClauseNode);
    }

    public OrderByClauseNode getOrderByClauseNode() {
        return this.orderByClauseNode;
    }

    public void setOrderByClauseNode(OrderByClauseNode orderByClauseNode) {
        this.orderByClauseNode = orderByClauseNode;
        this.addNodeInternal(orderByClauseNode);
    }

    public ForUpdateClauseNode getForUpdateClauseNode() {
        return this.forUpdateClauseNode;
    }

    public void setForUpdateClauseNode(ForUpdateClauseNode forUpdateClauseNode) {
        this.forUpdateClauseNode = forUpdateClauseNode;
        this.addNodeInternal(forUpdateClauseNode);
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    protected void addNodeInternal(SqlNode child) {
        if (child != null) {
            super.addNode(child);
        }
    }

    @Override
    public SqlNode copy() {
        CopyingVisitor visitor = new CopyingVisitor();
        SelectStatementNode clone = new SelectStatementNode();
        for (SqlNode child : this.children) {
            child.accept(visitor, clone);
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof SelectStatementNodeVisitor) {
            SelectStatementNodeVisitor v = (SelectStatementNodeVisitor)visitor;
            return v.visitSelectStatementNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }

    protected static class CopyingVisitor
    implements SelectClauseNodeVisitor<Void, SelectStatementNode>,
    FromClauseNodeVisitor<Void, SelectStatementNode>,
    WhereClauseNodeVisitor<Void, SelectStatementNode>,
    GroupByClauseNodeVisitor<Void, SelectStatementNode>,
    HavingClauseNodeVisitor<Void, SelectStatementNode>,
    OrderByClauseNodeVisitor<Void, SelectStatementNode>,
    ForUpdateClauseNodeVisitor<Void, SelectStatementNode> {
        protected CopyingVisitor() {
        }

        @Override
        public Void visitSelectClauseNode(SelectClauseNode node, SelectStatementNode p) {
            p.setSelectClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitFromClauseNode(FromClauseNode node, SelectStatementNode p) {
            p.setFromClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitWhereClauseNode(WhereClauseNode node, SelectStatementNode p) {
            p.setWhereClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitGroupByClauseNode(GroupByClauseNode node, SelectStatementNode p) {
            p.setGroupByClauseNode(node);
            return null;
        }

        @Override
        public Void visitHavingClauseNode(HavingClauseNode node, SelectStatementNode p) {
            p.setHavingClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitOrderByClauseNode(OrderByClauseNode node, SelectStatementNode p) {
            p.setOrderByClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitForUpdateClauseNode(ForUpdateClauseNode node, SelectStatementNode p) {
            p.setForUpdateClauseNode(node.copy());
            return null;
        }

        @Override
        public Void visitUnknownNode(SqlNode node, SelectStatementNode p) {
            AssertionUtil.assertUnreachable();
            return null;
        }
    }
}

