/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.ScriptReader;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.ScriptQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileScriptQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.dialect.Mssql2008Dialect;

public class ScriptReaderTest
extends TestCase {
    private SqlFileScriptQuery query;

    public void setUp() {
        MockConfig config = new MockConfig();
        config.dialect = new Mssql2008Dialect();
        this.query = new SqlFileScriptQuery(){

            public void prepare() {
            }
        };
        this.query.setConfig((Config)config);
        this.query.setCallerClassName("aaa");
        this.query.setCallerMethodName("bbb");
        this.query.setBlockDelimiter(config.dialect.getScriptBlockDelimiter());
        this.query.prepare();
    }

    public void testReadSql_delimiter() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("aaa;\n");
                buf.append("bbb\n");
                buf.append("go\n");
                buf.append("ccc\n");
                buf.append("ddd\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"aaa", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"bbb", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"ccc ddd", (String)reader.readSql());
        ScriptReaderTest.assertNull((Object)reader.readSql());
    }

    public void testReadSql_delimiterInLine() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("aaa; bbb; ccc;\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"aaa", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"bbb", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"ccc", (String)reader.readSql());
        ScriptReaderTest.assertNull((Object)reader.readSql());
    }

    public void testReadSql_sqlBlock() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("begin aaa; end\n");
                buf.append("go\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"begin aaa; end", (String)reader.readSql());
        ScriptReaderTest.assertNull((Object)reader.readSql());
    }

    public void testReadSql_sqlBlock_createTrigger() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("create trigger hoge begin aaa; end\n");
                buf.append("go\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"create trigger hoge begin aaa; end", (String)reader.readSql());
        ScriptReaderTest.assertNull((Object)reader.readSql());
    }

    public void testReadSql_notSqlBlock() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("start aaa; end\n");
                buf.append("go\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"start aaa", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"end", (String)reader.readSql());
    }

    public void testReadSql_commentBlock() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("select 1 ; /* aaa\n");
                buf.append("aaa */ select 2;");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertEquals((String)"select 1", (String)reader.readSql());
        ScriptReaderTest.assertEquals((String)"select 2", (String)reader.readSql());
        ScriptReaderTest.assertNull((Object)reader.readSql());
    }

    public void testReadSql_lineNumber() throws Exception {
        ScriptReader reader = new ScriptReader((ScriptQuery)this.query){

            protected BufferedReader createBufferedReader() throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append("/*\n");
                buf.append(" *\n");
                buf.append(" */\n");
                buf.append("select 1\n");
                buf.append("from \n");
                buf.append("hoge\n");
                StringReader reader = new StringReader(buf.toString());
                return new BufferedReader(reader);
            }
        };
        ScriptReaderTest.assertNotNull((Object)reader.readSql());
        ScriptReaderTest.assertEquals((int)4, (int)reader.getLineNumber());
    }
}

