/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.PostgresForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.PostgresPagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.jdbc.type.AbstractResultSetType;
import org.seasar.doma.jdbc.type.JdbcType;

public class PostgresDialect
extends StandardDialect {
    protected static final String UNIQUE_CONSTRAINT_VIOLATION_STATE_CODE = "23505";
    protected static final JdbcType<ResultSet> RESULT_SET = new PostgresResultSetType();

    public PostgresDialect() {
        this(new PostgresJdbcMappingVisitor(), new PostgresSqlLogFormattingVisitor(), new PostgresExpressionFunctions());
    }

    public PostgresDialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new PostgresSqlLogFormattingVisitor(), new PostgresExpressionFunctions());
    }

    public PostgresDialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new PostgresJdbcMappingVisitor(), sqlLogFormattingVisitor, new PostgresExpressionFunctions());
    }

    public PostgresDialect(ExpressionFunctions expressionFunctions) {
        this(new PostgresJdbcMappingVisitor(), new PostgresSqlLogFormattingVisitor(), expressionFunctions);
    }

    public PostgresDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new PostgresExpressionFunctions());
    }

    public PostgresDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "postgres";
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        PostgresForUpdateTransformer transformer = new PostgresForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        PostgresPagingTransformer transformer = new PostgresPagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        String state = this.getSQLState(sqlException);
        return UNIQUE_CONSTRAINT_VIOLATION_STATE_CODE.equals(state);
    }

    @Override
    public PreparedSql getIdentitySelectSql(String qualifiedTableName, String columnName) {
        if (qualifiedTableName == null) {
            throw new DomaNullPointerException("qualifiedTableName");
        }
        if (columnName == null) {
            throw new DomaNullPointerException("columnName");
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append("select currval('");
        buf.append(qualifiedTableName);
        buf.append('_').append(columnName);
        buf.append("_seq')");
        String rawSql = buf.toString();
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    public PreparedSql getSequenceNextValSql(String qualifiedSequenceName, long allocationSize) {
        if (qualifiedSequenceName == null) {
            throw new DomaNullPointerException("qualifiedSequenceName");
        }
        String rawSql = "select nextval('" + qualifiedSequenceName + "')";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return type == SelectForUpdateType.NORMAL || type == SelectForUpdateType.NOWAIT;
    }

    @Override
    public boolean supportsResultSetReturningAsOutParameter() {
        return true;
    }

    @Override
    public JdbcType<ResultSet> getResultSetType() {
        return RESULT_SET;
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new PostgresScriptBlockContext();
    }

    public static class PostgresScriptBlockContext
    implements ScriptBlockContext {
        protected boolean inBlock;

        @Override
        public void addKeyword(String keyword) {
            if ("$$".equals(keyword)) {
                this.inBlock = !this.inBlock;
            }
        }

        @Override
        public boolean isInBlock() {
            return this.inBlock;
        }
    }

    public static class PostgresExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
    }

    public static class PostgresSqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class PostgresJdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }

    public static class PostgresResultSetType
    extends AbstractResultSetType {
        public PostgresResultSetType() {
            super(1111);
        }
    }
}

